from fastapi import APIRouter, HTTPException, Depends
from app.db import database
from typing import Optional
from app.v1.models.platform.workforcevehicle import VehicleAssignment
from app.v1.services.platform import workforcevehicle as service

router = APIRouter()

@router.post("/", response_model=VehicleAssignment)
def create_vehicle_assignment(
    payload: VehicleAssignment,
    db: database.MongoDB = Depends(database.get_mongo_db)
):
    try:
        return service.create_vehicle_assignment_service(payload, db)
    except ValueError as e:
        raise HTTPException(status_code=400, detail=str(e))

@router.get("/{account_id}")
def get_vehicle_assignments(
    account_id: str,
    workforce_id: Optional[str] = None,
    vehicle_id: Optional[str] = None,
    db: database.MongoDB = Depends(database.get_mongo_db)
):
    return service.get_vehicle_assignments_service(account_id, workforce_id, vehicle_id, db)

@router.post("/unassign/{workforce_id}")
def unassign_vehicle(
    workforce_id: str,
    db: database.MongoDB = Depends(database.get_mongo_db)
):
    return service.unassign_vehicle_service(workforce_id, db)
