from fastapi import APIRouter, Depends
from app.db import database
from app.v1.models.platform.geofencerules import (
    GeofenceRuleCreate, GeofenceRule, GeofenceRuleUpdate, GeofenceRulesList
)
from app.v1.services.platform.geofencerules import (
    create_geofence_rule_service, get_geofence_rule_service,
    update_geofence_rule_service, delete_geofence_rule_service,
    list_geofence_rules_service
)

router = APIRouter()

@router.post("/", response_model=GeofenceRule)
async def create_geofence_rule(rule: GeofenceRuleCreate, db=Depends(database.get_mongo_db)):
    return await create_geofence_rule_service(rule, db)

@router.get("/", response_model=GeofenceRulesList)
async def list_geofence_rules(skip: int = 0, limit: int = 10, db=Depends(database.get_mongo_db)):
    return await list_geofence_rules_service(skip, limit, db)

@router.get("/{account_id}", response_model=GeofenceRule)
async def get_geofence_rule(account_id: str, db=Depends(database.get_mongo_db)):
    return await get_geofence_rule_service(account_id, db)

@router.post("/{account_id}", response_model=GeofenceRule)
async def post_geofence_rule(account_id: str, rule: GeofenceRuleCreate, db=Depends(database.get_mongo_db)):
    return await create_geofence_rule_service(rule, db)

@router.put("/{account_id}", response_model=GeofenceRule)
async def update_geofence_rule(account_id: str, update: GeofenceRuleUpdate, db=Depends(database.get_mongo_db)):
    return await update_geofence_rule_service(account_id, update, db)

@router.delete("/{account_id}", response_model=GeofenceRule)
async def delete_geofence_rule(account_id: str, db=Depends(database.get_mongo_db)):
    return await delete_geofence_rule_service(account_id, db)
