from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from typing import Optional
from datetime import datetime

from app.v1.services.platform.customers import (
    create_customer_service, get_customer_service,
    update_customer_service, delete_customer_service, list_customers_service,get_customers_service
)
from app.v1.dependencies.auth import get_current_userdetails
from app.v1.models.platform.customers import CustomerCreate, CustomerUpdate, Customer, CustomersList

router = APIRouter()

@router.post("/", response_model=Customer)
async def create_customer(customer: CustomerCreate, db=Depends(database.get_mongo_db)):
    return await create_customer_service(customer, db)

@router.get("/{account_id}", response_model=Customer)
async def get_customer(account_id: str, db=Depends(database.get_mongo_db)):
    print("1191919191919191919191991199")
    return await get_customer_service(account_id, db)

@router.put("/{account_id}", response_model=Customer)
async def update_customer(account_id: str, update: CustomerUpdate, db=Depends(database.get_mongo_db)):
    return await update_customer_service(account_id, update, db)

@router.delete("/{account_id}", response_model=Customer)
async def delete_customer(account_id: str, db=Depends(database.get_mongo_db)):
    return await delete_customer_service(account_id, db)

# @router.get("/", response_model=CustomersList)
# async def list_customers(skip: int = 0, limit: int = 10, db=Depends(database.get_mongo_db)):
#     return await list_customers_service(skip, limit, db)

@router.get("/", response_model=CustomersList)
async def get_customers(
    skip: int = 0,
    limit: int = 10,
    q: str = None,
    customer_type: str = None,
    account_id: str = None,
    from_date: Optional[datetime] = None,
    to_date: Optional[datetime] = None,
    sort_by: Optional[str] = None,          
    sort_order: Optional[str] = "asc",  
    db=Depends(database.get_mongo_db),
    current_user=Depends(get_current_userdetails)
):
    return get_customers_service(
        skip, limit, q, customer_type, account_id, from_date, to_date, sort_by, sort_order, db, current_user
    )

@router.get("/list", response_model=CustomersList)
async def list_customers(
    skip: int = 0,
    limit: int = 10,
    q: Optional[str] = None,
    db: database.MongoDB = Depends(database.get_mongo_db)
):
    return await list_customers_service(skip, limit, db)

