from pydantic import BaseModel, Field
from typing import Optional
from datetime import datetime

class VehicleAssignment(BaseModel):
    account_id: str = Field(..., description="Identifier for the account")
    user_id: str = Field(..., description="Identifier for the user")
    workforce_id: str = Field(..., description="Identifier for the workforce member")
    vehicle_id: str = Field(..., description="Identifier for the vehicle")
    assigned_from: datetime = Field(..., description="Start time")
    assigned_to: Optional[datetime] = Field(None, description="End time (null if ongoing)")
    status: bool = Field(..., description="Assignment active/inactive")
    is_permanent: bool = Field(..., description="True = vehicle can't be reassigned")
    created_date: datetime = Field(default_factory=datetime.utcnow)
    updated_date: datetime = Field(default_factory=datetime.utcnow)
