from pydantic import BaseModel, Field
from bson import ObjectId
from datetime import datetime
from typing import Optional, List

class WorkforceCategoryBase(BaseModel):
    account_id: str
    user_id: str
    category_name: str
    description: str
    shift_hours: int
    capacity_jobs: int

    # Optional fields
    created_date: Optional[datetime] = Field(default_factory=datetime.utcnow)
    last_updated: Optional[datetime] = Field(default_factory=datetime.utcnow)
    status: Optional[str] = "active"

class WorkforceCategory(WorkforceCategoryBase):
    id: str
    workforce_category_id: Optional[int] = None

    class Config:
        arbitrary_types_allowed = True
        json_encoders = {ObjectId: str}
        allow_population_by_field_name = True

class WorkforceCategoryResponse(BaseModel):
    workforcecategory_id: str
    account_id: str
    user_id: str
    category_name: str
    description: str
    shift_hours: int
    capacity_jobs: int
    created_date: Optional[datetime] = None
    last_updated: Optional[datetime] = None
    status: Optional[str] = None
    workforce_category_id: Optional[int] = None

class WorkforceCategoryResponseList(BaseModel):
    total_count: int
    workforce_categories: List[WorkforceCategoryResponse]  # Ensure this matches the response key

class WorkforceCategoryUpdate(BaseModel):
    account_id: Optional[str]
    user_id: Optional[str]
    category_name: Optional[str]
    description: Optional[str]
    shift_hours: Optional[int]
    capacity_jobs: Optional[int]
    status: Optional[str]

class WorkforceCategoryCreate(WorkforceCategoryBase):
    pass

class WorkforceCategoryInDB(WorkforceCategoryBase):
    pass