from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware
from dotenv import load_dotenv
from app.middleware import InputSanitizationMiddleware  
from starlette.exceptions import HTTPException as StarletteHTTPException

if not load_dotenv():
    print("Could not load .env file or it is empty. Please check if it exists and is readable.")
    exit(1)

from app.api.v1.apps import AppEngineTest
app = FastAPI()

origins = [
    "https://localhost:3000",
    "https://localhost:8000",
    "https://127.0.0.1:8000",
    "https://www.thought.cx",  # If you have HTTPS set up.
    "http://www.thought.cx",  # If you have HTTPS set up.

]

app.add_middleware(
    CORSMiddleware,
    allow_origins=origins, #    
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)

app.include_router(AppEngineTest.router, prefix="/v1/testcall", tags=["App Call Latest"])


