from app.db import database

COLLECTION_NAME = "monitoring_settings"

def get_monitoring_settings(account_id: str, db: database.MongoDB) -> dict:
    return db[COLLECTION_NAME].find_one({"account_id": account_id}) or {}

def update_monitoring_settings(account_id: str, data: dict, db: database.MongoDB) -> dict:
    db[COLLECTION_NAME].update_one({"account_id": account_id}, {"$set": data}, upsert=True)
    return db[COLLECTION_NAME].find_one({"account_id": account_id})
