from fastapi import APIRouter, HTTPException, Depends
from app.db import database
from app.v1.models.platform.workforcetimesheet import WorkforceTimesheet
from app.v1.services.platform import workforcetimesheet as service

router = APIRouter()

@router.post("/", response_model=WorkforceTimesheet)
def create_timesheet(
    data: WorkforceTimesheet,
    db: database.MongoDB = Depends(database.get_mongo_db)
):
    try:
        return service.create_timesheet_entry(data, db)
    except Exception as e:
        raise HTTPException(status_code=400, detail=str(e))

@router.get("/{account_id}")
def list_timesheets(
    account_id: str,
    db: database.MongoDB = Depends(database.get_mongo_db)
):
    return service.get_timesheet_entries(account_id, db)
