from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.integrations import IntegrationSettings
from app.v1.services.platform import integrations as integration_service

router = APIRouter()

@router.get("/{account_id}", response_model=IntegrationSettings)
def get_settings(account_id: str,db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return integration_service.get_integration_settings(account_id,db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

@router.post("/{account_id}", response_model=IntegrationSettings)
def update_settings(account_id: str, settings: IntegrationSettings, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return integration_service.update_integration_settings(account_id, settings.dict(), db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
