from fastapi import Depends, HTTPException, Security
from fastapi.security import OAuth2PasswordBearer

# This is where the client would send the token
oauth2_scheme = OAuth2PasswordBearer(tokenUrl="login")

def get_current_user(token: str = Depends(oauth2_scheme)):
    # Here, you'd typically decode the token and fetch the user info
    # For this example, I'll mock this
    user_payload = decode_token(token)
    
    if user_payload:
        return user_payload
    else:
        raise HTTPException(status_code=401, detail="Invalid or expired token")
    

def get_current_account(token: str = Depends(oauth2_scheme)):
    # Here, you'd typically decode the token and fetch the account info
    # For this example, I'll mock this
    account_payload = decode_token(token)
    
    if account_payload:
        return account_payload
    else:
        raise HTTPException(status_code=401, detail="Invalid or expired token")


def decode_token(token: str):
    # This function would decode the JWT and fetch user information
    # For the sake of this example, let's assume any token gives a mock user
    return {"username": "sampleuser", "email": "user@example.com"}
