from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.availability import AvailabilitySettings
from app.v1.services.platform import availability as availability_service

router = APIRouter()

@router.get("/{account_id}", response_model=AvailabilitySettings)
def get_settings(account_id: str, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return availability_service.get_availability_settings(account_id,db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

@router.post("/{account_id}", response_model=AvailabilitySettings)
def update_settings(account_id: str, settings: AvailabilitySettings, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return availability_service.update_availability_settings(account_id, settings.dict(), db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
