from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.account_settings import AccountSettings
from app.v1.services.platform import account_settings as account_settings_service

router = APIRouter()

@router.get("/{account_id}", response_model=AccountSettings)
def get_settings(account_id: str, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return account_settings_service.get_account_settings(account_id,db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

@router.post("/{account_id}", response_model=AccountSettings)
def update_settings(account_id: str, settings: AccountSettings, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return account_settings_service.update_account_settings(account_id, settings.dict(), db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
