import React from 'react';
import { useNavigate } from 'react-router-dom';
import { Helmet } from 'react-helmet';

const WebFeatures = () => {
    const navigate = useNavigate();
    function handleClick() {
        navigate('/signup');
    }

    return (
        <>
            <Helmet>
                <title>Generative AI Chatbot for your website with Thought</title>
                <meta name="description" content="Turn your website and digital content into a smart AI chatbot in minutes. Thought makes it easy to enhance customer interactions with advanced AI technology." />
            </Helmet>

            <div className="website-container">
                <center>
                <div className='content-container'>
                <section className="main-section">

                {/* Main Banner Section */}
                    <h1>Transform Website into an AI Chatbot in seconds!</h1>
                    <h3>Content  from Website, YouTube videos, Google Drive, Files & Social Media</h3>
                    <p>Introducing the future of customer engagement: convert your website, YouTube videos, Google Drive documents, and more into a fully functional AI chatbot in minutes with Thought. Redefine user interaction with unparalleled AI efficiency.</p>
                    <br/>
                    <button onClick={handleClick}>Launch Your AI Chatbot Now</button>

                </section>
                {/* Features Section */}
                <section className="features-section">
                    {/* Feature 1 */}
                    <div className="feature">
                        <div className="feature-content">
                            <h2><span className="material-symbols-outlined category-icon">flash_on</span> Instant Integration: Web to Chatbot in a Snap</h2>
                            <p>Thought effortlessly turns your existing website and digital content into a smart, conversational AI chatbot. Whether it's your company's site, instructional YouTube videos, or critical documents in Google Drive, integrate them in minutes and start engaging with your audience on a whole new level.</p>
                        </div>
                    </div>

                    {/* Feature 2 */}
                    <div className="feature">
                        <div className="feature-content">
                            <h2><span className="material-symbols-outlined category-icon">smart_toy</span> Intelligent Conversations: Beyond Basic Interactions</h2>
                            <p>Our platform doesn’t just mimic human conversation; it understands and anticipates the needs of your users. By analyzing the context and content from your integrated sources, Thought delivers responses that are not just relevant but genuinely helpful, driving deeper engagement.</p>
                        </div>
                    </div>

                    {/* Feature 3 */}
                    <div className="feature">
                        <div className="feature-content">
                            <h2><span className="material-symbols-outlined category-icon">integration_instructions</span> Seamless Content Utilization: Your Digital Assets as Conversation Fuel</h2>
                            <p>Thought’s unique capability to integrate diverse content types – from text and documents to video – ensures that your AI chatbot is not only knowledgeable but also incredibly resourceful. Utilize your existing digital assets to fuel engaging, informative, and interactive conversations.</p>
                        </div>
                    </div>

                    {/* Feature 4 */}
                    <div className="feature">
                        <div className="feature-content">
                            <h2><span className="material-symbols-outlined category-icon">update</span> Rapid Deployment: AI-Ready in Minutes</h2>
                            <p>Forget about lengthy development times. With Thought, your AI chatbot goes from concept to reality in minutes, not months. Empower your business with next-generation customer service that’s ready to deploy at a moment’s notice, keeping you ahead of the curve.</p>
                        </div>
                    </div>
                </section>
                </div>
                </center>
            </div>
        </>        
    );
};

export default WebFeatures;
