import React from 'react';
import { Helmet } from 'react-helmet';

const Terms = () => {

return(
<>
<Helmet>
    <title>Terms and Conditions: Guidelines for Using Thought</title>
    <meta name="description" content="Review the Terms and Conditions for using Thought - your guide to understanding the rules, obligations, and rights when engaging with our AI-driven customer experience platform. Ensure a compliant and informed use of our services." />
</Helmet>

        <div className="website-container">
            <center>
                <div className='content-container'>
                    <section className="main-content-section">
                        <h1>Terms and Conditions for Thought - Customer Experience Platform</h1>

                        {/* Introduction Section */}
                        <h2>1. Introduction</h2>
                        <h3>1.1 Overview</h3>
                        <p>This document outlines the terms for using Thought's Customer Experience Platform, an AI-driven service designed to enhance customer interactions through advanced technology, contextual understanding, and integration with various data sources and third-party APIs.</p>
                        <h3>1.2 Acceptance of Terms</h3>
                        <p>By using Thought's services, users agree to these terms.</p>

                        {/* Use of Service Section */}
                        <h2>2. Use of Service</h2>
                        <h3>2.1 User Responsibilities</h3>
                        <p>Users must use the service responsibly, adhering to all applicable laws and regulations. Misuse or abuse of the service is prohibited.</p>
                        <h3>2.2 Service Modifications</h3>
                        <p>Thought reserves the right to modify or discontinue the service or any part thereof without notice at any time.</p>

                        {/* Third-Party Integrations and APIs Section */}
                        <h2>3. Third-Party Integrations and APIs</h2>
                        <h3>3.1 Integration with Third-Party Services</h3>
                        <p>Thought integrates with various third-party services and APIs to enhance functionality. Users are responsible for any interactions with these third-party services.</p>
                        <h3>3.2 User Responsibility for Third-Party Services</h3>
                        <p>Users must comply with the terms and conditions of any third-party services used in conjunction with Thought's platform.</p>

                        {/* Language Models and AI Agents Section */}
                        <h2>4. Language Models and AI Agents</h2>
                        <h3>4.1 Description of AI Agents</h3>
                        <p>The platform employs AI agents to interpret customer intent and business context, generating appropriate responses and content.</p>
                        <h3>4.2 Limitations and Risks</h3>
                        <p>AI-generated content may have limitations and potential for error. Thought is not responsible for inaccuracies or mistakes in AI-generated content.</p>

                        {/* Pricing and Payment Section */}
                        <h2>5. Pricing and Payment</h2>
                        <h3>5.1 Subscription Fees</h3>
                        <p>Pricing is based on a monthly subscription model, varying by the number of agents and responses used.</p>
                        <h3>5.2 Payment Terms</h3>
                        <p>Payments are due in accordance with the billing schedule and are non-refundable.</p>
                        <h3>5.3 No Refund Policy</h3>
                        <p>All payments to Thought are final and non-refundable.</p>

                        {/* Intellectual Property Section */}
                        <h2>6. Intellectual Property</h2>
                        <h3>6.1 Ownership</h3>
                        <p>All intellectual property rights related to the Thought platform and its content are the sole property of Thought.</p>
                        <h3>6.2 User-Generated Content</h3>
                        <p>Users retain ownership of their content, but grant Thought a license to use it as necessary for providing the service.</p>

                        {/* Disclaimers and Limitations of Liability Section */}
                        <h2>7. Disclaimers and Limitations of Liability</h2>
                        <h3>7.1 Accuracy of AI-Generated Content</h3>
                        <p>Thought does not guarantee the accuracy of AI-generated content and is not liable for errors or omissions.</p>
                        <h3>7.2 Limitation of Liability</h3>
                        <p>Thought's liability is limited to the maximum extent permitted by law.</p>

                        {/* Data Privacy and Security Section */}
                        <h2>8. Data Privacy and Security</h2>
                        <h3>8.1 Data Handling</h3>
                        <p>Thought adheres to strict data privacy and security protocols to protect user data.</p>
                        <h3>8.2 Compliance with Privacy Laws</h3>
                        <p>The platform complies with all applicable U.S. data protection and privacy laws.</p>

                        {/* Termination and Suspension Section */}
                        <h2>9. Termination and Suspension</h2>
                        <h3>9.1 User Termination</h3>
                        <p>Users may terminate their accounts at any time.</p>
                        <h3>9.2 Company's Right to Suspend or Terminate</h3>
                        <p>Thought reserves the right to suspend or terminate user accounts for violations of these terms.</p>

                        {/* Governing Law and Dispute Resolution Section */}
                        <h2>10. Governing Law and Dispute Resolution</h2>
                        <h3>10.1 Jurisdiction</h3>
                        <p>These terms are governed by the laws of the United States of America.</p>
                        <h3>10.2 Dispute Resolution</h3>
                        <p>Any disputes arising under these terms will be resolved through arbitration in the United States.</p>

                        {/* Miscellaneous Section */}
                        <h2>11. Miscellaneous</h2>
                        <h3>11.1 Amendments</h3>
                        <p>Thought reserves the right to amend these terms at any time.</p>
                        <h3>11.2 Entire Agreement</h3>
                        <p>These terms constitute the entire agreement between the user and Thought.</p>

                        {/* Additional Provisions Specific to the Customer Experience Platform */}
                        <h2>12. Additional Provisions Specific to the Customer Experience Platform</h2>
                        <h3>12.1 Platform Components</h3>
                        <p>Detailed description of platform components (Vector Store, AI Engine, etc.) and their functionalities.</p>
                        <h3>12.2 Content Rendering Mechanisms</h3>
                        <p>Specific terms for content rendering, including handling of YouTube videos, website links, and documents.</p>
                        <h3>12.3 Data Collection and Storage</h3>
                        <p>Details on how customer data is collected, stored, and used, including the use of local storage or cookies.</p>
                        <h3>12.4 Flow and Context Engine</h3>
                        <p>Description of how the Flow and Context Engine operates, including data processing and API calls.</p>
                    </section>
                </div>
            </center>
        </div>
    </>
    )
};

export default Terms;
