import React from 'react';
import { Helmet } from 'react-helmet';

const PrivacyPolicy = () => {
return(
<>        
<Helmet>
    <title>Privacy Policy: Safeguarding Your Data at Thought</title>
    <meta name="description" content="Thought's Privacy Policy - our commitment to protecting your privacy and data. Learn how we handle and secure your information in our AI-driven customer experience platform." />
</Helmet>

        <div className="website-container">
            <center>
                <div className='content-container'>
                <section className="main-content-section">
                        <h1>Privacy Policy for Thought - Customer Experience Platform</h1>

                        {/* Introduction Section */}
                        <h2>Introduction</h2>
                        <p>This Privacy Policy outlines how Thought ("we," "us," "our") collects, uses, processes, and discloses information, including personal data, in relation to your use of the Thought Customer Experience Platform. By accessing and using our platform, you agree to the collection and use of information in accordance with this policy.</p>

                        {/* Information Collection Section */}
                        <h2>Information Collection</h2>
                        <h3>Types of Data Collected</h3>
                        <ul>
                            <li><strong>Personal Identification Information:</strong> Includes name, email, phone number, and other personal details provided by the user.</li>
                            <li><strong>Usage Data:</strong> Data generated from interactions with the AI agents, such as chat history and content preferences.</li>
                            <li><strong>Technical Data:</strong> Includes IP addresses, browser type, and operating system.</li>
                            <li><strong>Cookies and Tracking Data:</strong> Utilized to track activity on our platform and store certain information.</li>
                        </ul>
                        <h3>Method of Collection</h3>
                        <ul>
                            <li><strong>User-Provided Information:</strong> Collected when users input or upload data to the platform.</li>
                            <li><strong>AI Interactions:</strong> Data generated from interactions with our AI agents and content sections.</li>
                            <li><strong>Third-Party Sources:</strong> Information received from integrated third-party apps and services.</li>
                        </ul>

                        {/* Use of Data Section */}
                        <h2>Use of Data</h2>
                        <ul>
                            <li><strong>Service Provision:</strong> To operate and maintain our platform, including AI-driven content generation.</li>
                            <li><strong>Personalization:</strong> To tailor content and interactions based on user behavior and preferences.</li>
                            <li><strong>Communication:</strong> To communicate with users about platform updates or offers.</li>
                            <li><strong>Analytics and Improvement:</strong> To enhance platform functionalities and user experience.</li>
                        </ul>

                        {/* Data Sharing and Disclosure Section */}
                        <h2>Data Sharing and Disclosure</h2>
                        <ul>
                            <li><strong>Third-Party Integrations:</strong> Data may be shared with integrated services like Google Bard, OpenAI models, and Hugging Face for enhanced AI functionalities.</li>
                            <li><strong>Legal Compliance:</strong> We may disclose information where required by law or to respond to legal processes.</li>
                            <li><strong>Business Transfers:</strong> In case of a merger, acquisition, or asset sale, user information may be transferred.</li>
                        </ul>

                        {/* Data Storage and Security Section */}
                        <h2>Data Storage and Security</h2>
                        <ul>
                            <li><strong>Storage Location:</strong> Data is stored on secure servers, with measures in place to protect against unauthorized access.</li>
                            <li><strong>Security Measures:</strong> We implement a variety of security measures including encryption and access controls.</li>
                        </ul>

                        {/* User Rights and Control Section */}
                        <h2>User Rights and Control</h2>
                        <ul>
                            <li><strong>Access and Rectification:</strong> Users can access and update their personal information via their account settings.</li>
                            <li><strong>Deletion:</strong> Users have the right to request the deletion of their personal data.</li>
                            <li><strong>Opt-Out:</strong> Users can opt out of certain uses of their data, particularly data sharing with third-party AI models and apps.</li>
                        </ul>

                        {/* International Data Transfer Section */}
                        <h2>International Data Transfer</h2>
                        <p>Transfer Mechanisms: Data may be transferred and maintained on computers located outside of your state or country, where data protection laws may differ.</p>

                        {/* Children's Privacy Section */}
                        <h2>Children's Privacy</h2>
                        <p>Our service does not address anyone under the age of 18 ("Children"). We do not knowingly collect personally identifiable information from Children.</p>

                        {/* Changes to This Privacy Policy Section */}
                        <h2>Changes to This Privacy Policy</h2>
                        <p>We may update our Privacy Policy from time to time. We will notify users of any changes by posting the new Privacy Policy on this page.</p>

                        {/* Contact Us Section */}
                        <h2>Contact Us</h2>
                        <p>If you have any questions about this Privacy Policy, please <a href="/contact">contact</a> our team to learn more.</p>
                    </section>
                </div>
            </center>
        </div>
    </>
);
};

export default PrivacyPolicy;
