import React from 'react';
import { Link } from 'react-router-dom';
import '../themes/blue/footer.css'; // Import the stylesheet

const Footer = () => {
    return (
        <footer className="footer-container">
            <div className="content-wrap">
                {/* Logo and Description */}
                <div className="logo-section">
                    <a href='/' className="logo-text">
                        <span className="material-symbols-outlined" style={{ marginRight: '5px' }}>filter_vintage</span>
                        Thought
                    </a>
                    <p style={{textAlign:'left'}}>
                    Explore how Thought's AI transforms customer interactions through personalized and dynamic content. 
                    Leveraging various Large Language Models (LLMs) and Retrieval-Augmented Generation (RAG), it delivers highly relevant content to users, enriching their experience with insights drawn directly from the business context.</p>
                </div>
                
                {/* Navigation Links */}
                <div className="columnfooter">
                    <h3 style={{textAlign:'left'}}>Explore Thought</h3>
                    <Link to="/how-it-works">How It Works</Link><br/>
                    <Link to="/applications">Applications</Link><br/>
                    <Link to="/website-generativeai-chatbot">Website to Interactive</Link><br/>
                    <Link to="/generativeai-team-assist">Build your AI Teams</Link><br/>
                    <Link to="/about">About Us</Link><br/><br/>
                    <h3 style={{textAlign:'left'}}>Terms</h3>
                    <Link to="/terms">Terms of Service</Link><br/>
                    <Link to="/privacy">Privacy Policy</Link>

                </div>

                {/* Legal Links */}
                <div className="columnfooter">
                <h3 style={{textAlign:'left'}}>Get Started</h3>
                    <Link to="/pricing">Pricing</Link><br/>
                    <Link to="/contact">Contact Us</Link><br/>
                    <Link to="/login">Login</Link><br/>
                    <Link to="/login">Signup</Link><br/>
                    <Link to='/experience' >Interact <span className="material-symbols-outlined" style={{padding:'0px', fontSize:'20px'}} >deployed_code</span></Link>
                </div>

                {/* Copyright Notice */}
                <div className="copyright">
                    <p>© 2024 Thought. Empowering businesses with AI.</p>
                </div>
            </div>
        </footer>
    );
}

export default Footer;
