import React from 'react';
import { useNavigate } from 'react-router-dom';
import { Helmet } from 'react-helmet';

const WebFeatures = () => {
    const navigate = useNavigate();
    function handleClick() {
        navigate('/signup');
      }

    return (
        <>
    <Helmet>
    <title>Thought: Features of Customer Experience Platform</title>
    <meta name="description" content="Explore Thought - the AI-driven platform revolutionizing customer engagement by understanding business contexts and crafting personalized content." />
    </Helmet>

        <div className="website-container">
            <center>
            <div className='content-container'>
            <section className="main-section">

            {/* Main Banner Section */}
                <h1>Unveiling the Power of AI in Customer Experience</h1>
                <p>Discover how our platform transforms digital interactions into extraordinary customer journeys with state-of-the-art AI technology.</p>
                <button onClick={handleClick}>Start Building The Future Now</button>

            </section>
            {/* Features Section */}
            <section className="features-section" >
                {/* Feature 1 */}
                <div className="feature">
                    <div className="feature-content">
                        <h2><span className="material-symbols-outlined category-icon">database</span> Retrieval: Seamless Integration with Varied Data Sources</h2>
                        <p>Our platform extends beyond traditional boundaries, offering seamless integration with an array of data sources including websites, videos, and cloud storage solutions like Google Drive and Dropbox. It powers a sophisticated <strong>Retrieval-Augmented Generation (RAG) pipeline</strong> , leveraging the latest in Language Model (LLM) technology. Through detailed analysis and interpretation, it guarantees responses are not only pertinent but laden with deep insights, fostering enhanced user engagement through intelligent, context-aware dialogues.</p>
                    </div>
                </div>

                {/* Feature 1 */}
                <div className="feature">
                    <div className="feature-content">
                        <h2><span className="material-symbols-outlined category-icon">settings_accessibility</span> Contextual : Enhanced AI Content Interpretation</h2>
                        <p>Empowering advanced content comprehension, our platform utilizes AI to deeply analyze <strong>user's context</strong> and understand content across diverse data sources. This meticulous process ensures every user query is met with responses that are not just relevant but infused with valuable insights, crafting a richer, more engaging interaction.</p>
                    </div>
                </div>

                <div className="feature">
                    <div className="feature-content">
                        <h2><span className="material-symbols-outlined category-icon">integration_instructions</span> Flows: Integrative Application Ecosystem</h2>
                        <p>Our platform revolutionizes workflow efficiency and system connectivity with its native ability for effortless app integrations. It allows for smooth data interchange with essential platforms like Twilio, Twitter, Slack, and more, including the capability to integrate your own application stack. This opens up unparalleled operational capabilities, enabling your apps to interact contextually based on customer interests, through a dynamic system we term 'flows'.</p>
                    </div>
                </div>

                <div className="feature">
                    <div className="feature-content">
                        <h2><span className="material-symbols-outlined category-icon">psychology</span> Generation: Next-Gen Generative AI</h2>
                        <p>At the forefront of AI innovation, our platform's generative capabilities are unmatched. With the power to produce dynamic, contextually aware content, it not only responds to but anticipates user needs, pushing the boundaries of interactive experiences. Utilizing state-of-the-art language models, it crafts responses that elevate customer engagement, setting new industry standards for AI-driven interactions.</p>
                    </div>
                </div>
            </section>
            </div>
            </center>
        </div>
        </>        
    );
};

export default WebFeatures;
