import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom';
import axios from 'axios';
import { Helmet } from 'react-helmet';

const WebContact = () => {
    const navigate = useNavigate();
    const [contactForm, setContactForm] = useState({
        name: '',
        email: '',
        mobile: '',
        company: '',
        details: ''
    });
    const [errorMessage, setErrorMessage] = useState('');
    const [successMessage, setSuccessMessage] = useState('');

    const handleChange = (e) => {
        const { name, value } = e.target;
        setContactForm(prevState => ({
            ...prevState,
            [name]: value
        }));
    };

    const handleSubmit = async (e) => {
        e.preventDefault();
        try {
            // Assuming you have an endpoint to handle contact form submission
            await axios.post('/support/', contactForm);
            setSuccessMessage(' Your Request has been Submitted... Our team will get back to you at the earliest! ');
            //navigate('/thank-you'); // Redirect user to a thank you page or handle as needed
        } catch (error) {
            setErrorMessage('Failed to submit the contact form. Please try again.');
        }
    };

    return (
        <>
    <Helmet>
        <title>Contact Us: Reach Out to Thought Today</title>
        <meta name="description" content="Get in touch with the Thought team for any queries, support, or feedback. Discover how to contact us through various channels. We're here to help enhance your AI-driven customer experience journey." />
    </Helmet>
        <div className="container">
            <h2>Contact Us</h2>
            {successMessage && <p className='success'>{successMessage}</p>}
            <p>Fill out the form below to get in touch with us.</p>
            <form onSubmit={handleSubmit}>
                <input
                    type="text"
                    name="name"
                    placeholder="Your Name"
                    value={contactForm.name}
                    onChange={handleChange}
                    required
                />
                <input
                    type="email"
                    name="email"
                    placeholder="Email Address"
                    value={contactForm.email}
                    onChange={handleChange}
                    required
                />
                <input
                    type="text"
                    name="mobile"
                    placeholder="Mobile Number"
                    value={contactForm.mobile}
                    onChange={handleChange}
                />
                <input
                    type="text"
                    name="company"
                    placeholder="Company Name"
                    value={contactForm.company}
                    onChange={handleChange}
                />
                <textarea
                    name="details"
                    placeholder="Your Message"
                    value={contactForm.details}
                    onChange={handleChange}
                    rows={5}
                    required
                ></textarea>
                <h2><span className="material-symbols-outlined" >store</span>Thoughts Inc.</h2>
                <h3><span className="material-symbols-outlined" >pin_drop</span> San Francisco, CA <br/> <span className="material-symbols-outlined" >phone</span> +1-415-217-9666</h3>
                {errorMessage && <p className='error'>{errorMessage}</p>}
                <button type="submit" className='submit-btn'>
                    Submit
                </button>
            </form>
        </div>
    </>
);

};

export default WebContact;
