import React, {useState} from 'react';
import { useNavigate } from 'react-router-dom';
import { Helmet } from 'react-helmet';

const WebFeatures = () => {
    const navigate = useNavigate();
    function handleClick() {
        navigate('/signup');
    }

// Data for Functional Applications and Industries
const functionalApplications = [
    {
      id: 'personalization',
      title: 'Deep Personalization',
      description: 'Our platform goes beyond generic interactions. Imagine speaking directly to each customer’s unique needs and interests, creating a connection that feels both personal and profound.',
      icon: 'settings_accessibility',
      keywords: ['customization', 'unique experience', 'user preferences']
    },
    {
      id: 'customer-engagement',
      title: 'Engaging Customer Conversations',
      description: 'We help you spark meaningful conversations. By understanding the context of each interaction, our platform ensures that every message resonates deeply with your audience.',
      icon: 'supervised_user_circle',
      keywords: ['interactive', 'customer journey', 'relationship building']

    },
    {
      id: 'lead-generation',
      title: 'Smart Lead Generation',
      description: 'Transform the way you attract prospects. Our intelligent platform identifies potential leads, engaging them with the right content at the right time to turn interest into action.',
      icon: 'contact_phone',
      keywords: ['prospect engagement', 'conversion', 'marketing automation']

    },
    {
      id: 'visitor-engagement',
      title: 'Dynamic Visitor Engagement',
      description: 'Make every website visit unforgettable. By tailoring content and interactions to each visitor, we help you create compelling experiences that capture attention and encourage return visits.',
      icon: 'deployed_code_account',
      keywords: ['website personalization', 'user retention', 'bounce rate reduction']

    },
    {
      id: 'customer-support',
      title: 'Responsive Customer Support',
      description: 'Revolutionize your support system with responsive chatbots that provide instant, accurate help. Our platform ensures your customers always find the support they need, right when they need it.',
      icon: 'ar_on_you',
      keywords: ['chatbots', 'instant help', 'support automation']

    },
    {
      id: 'research-learn',
      title: 'Effortless Research & Learning',
      description: 'Unlock a world of information with ease. Our platform sifts through extensive data, offering insights and answers that fuel learning and decision-making.',
      icon: 'manage_search',
      keywords: ['knowledge discovery', 'educational resources', 'information access']
    }
  ];

  const industries = [
    {
        id: 'it-support',
        title: 'IT & Support: Transforming Tech Solutions',
        description: 'Lead the way in tech innovation by leveraging our platform for lead generation and personalized content delivery, ensuring your solutions resonate with user needs and industry trends.',
        icon:'terminal',
        keywords: ['technology advancement', 'IT solutions', 'IT Staffing', 'support services', 'IT support', 'cloud', 'infrastructure', 'iaas', 'saas', 'paas', 'devops', 'AIOps']

      },
      {
        id: 'saas',
        title: 'SaaS: Enhancing Product Adoption',
        description: 'Elevate your SaaS offerings with comprehensive support and dynamic documentation. Engage users in real-time, providing personalized assistance and fostering deep product understanding and loyalty.',
        icon:'subscriptions',
        keywords: ['software as a service', 'user engagement', 'Customer Growth', 'product support', 'support services', 'IT support', 'cloud', 'infrastructure', 'iaas', 'saas', 'paas', 'devops', 'AIOps']
      },
      {
        id: 'travel-tourism',
        title: 'Travel & Tourism: Curated Travel Experiences',
        description: 'Transform how travelers explore and engage with destinations. Our platform delivers personalized content and recommendations, inspiring journeys and generating leads for unforgettable experiences.',
        icon:'flight_takeoff',
        keywords: ['travel personalization', 'destination discovery', 'Booking', 'ticketing', 'tourist engagement']

      },
    {
      id: 'ecommerce',
      title: 'E-commerce: Personalized Shopping Journeys',
      description: 'In the dynamic world of e-commerce stores, our platform stands out by guiding customers to their perfect products through personalized content and recommendations, enhancing the shopping experience and boosting conversions.',
      icon:'shopping_cart',
      keywords: ['online shopping', 'customer recommendations', 'retail innovation', 'ecommerce', 'products', 'store', 'retail','catalog']
    },
    {
      id: 'healthcare',
      title: 'Healthcare: Compliant and Customized Care',
      description: 'Our HIPAA-compliant solutions transform patient care by providing tailored health information and support, ensuring privacy while enhancing patient engagement and understanding.',
      icon:'local_hospital',
      keywords: ['patient engagement', 'health information', 'medical support', 'hospitals' , 'clinics' , 'EMR']

    },
    {
      id: 'education',
      title: 'Education: Enriched Learning Experiences',
      description: 'Revolutionize education with content that adapts to each learner’s intent and context. Our platform facilitates research and exploration, making learning a personalized and engaging journey for every student.',
      icon:'school',
      keywords: ['personalized learning', 'colleges', 'universities', 'schools','educational content', 'student engagement']
    },
    {
      id: 'government',
      title: 'Government: Smart, Scalable Public Solutions',
      description: 'Empower public services with our Enterprise RAG solutions. From managing vast datasets to enhancing user interaction, we deliver efficient, user-friendly access to important information and services.',
      icon:'account_balance',
      keywords: ['public service efficiency', 'data management', 'governmental interaction', 'e-govenance', 'egovernance']
    }
  ];
  
const [searchApp, setSearchApp] = useState('');
const [searchIndustry, setSearchIndustry] = useState('');

const filteredApplications = functionalApplications.filter(app =>
  app.title.toLowerCase().includes(searchApp.toLowerCase()) ||
  app.description.toLowerCase().includes(searchApp.toLowerCase()) ||
  app.keywords.some(keyword => keyword.toLowerCase().includes(searchApp.toLowerCase()))
);

const filteredIndustries = industries.filter(industry =>
  industry.title.toLowerCase().includes(searchIndustry.toLowerCase()) ||
  industry.description.toLowerCase().includes(searchIndustry.toLowerCase()) ||
  industry.keywords.some(keyword => keyword.toLowerCase().includes(searchIndustry.toLowerCase()))
);


return (
<>
<Helmet>
  <title>Thought: Applications & Use cases</title>
  <meta name="description" content="Explore Thought - the AI-driven platform revolutionizing customer engagement by understanding business contexts and crafting personalized content." />
</Helmet>

    <div className="website-container">
            <center>
            <div className='content-container'>
            <section className="main-section">

            {/* Main Banner Section */}
                <h1 style={{textAlign:'center'}}>Revolutionizing <strong>Customer Experience<span className="material-symbols-outlined" style={{fontSize:'50px'}}>sentiment_very_satisfied</span></strong> with Gen AI </h1>
                <p>Transform the way you engage with your audience through our CX platform, which breathes life into both static and dynamic content from a myriad of sources. By tailoring this content to be more meaningful and relevant, we not only meet but exceed user expectations, leaving them delighted and fulfilled.  
                
                </p>
                <button onClick={handleClick}>Get Started</button>

            </section>
            </div>
            </center>

        <div className='apps-container' style={{ display: 'flex', justifyContent: 'space-between' }}>
            {/* Functional Applications Column */}
            <div className="column">
                <input type="text" placeholder="Search Applications..." onChange={(e) => setSearchApp(e.target.value)} />
                {filteredApplications.map(app => (
                    <div key={app.id} className="feature">
                        <h2 style={{color:'#333'}}><span className="material-symbols-outlined">{app.icon}</span> {app.title}</h2>
                        <p>{app.description}</p>
                    </div>
                ))}
            </div>

            {/* Industries Column */}
            <div className="column">
                <input type="text" placeholder="Search Industries..." onChange={(e) => setSearchIndustry(e.target.value)} />
                {filteredIndustries.map(industry => (
                    <div key={industry.id} className="feature">
                        <h2 style={{color:'#333'}}><span className="material-symbols-outlined">{industry.icon}</span> {industry.title}</h2>
                        <p>{industry.description}</p>
                    </div>
                ))}
            </div>
        </div>
    </div>
</>)
};

export default WebFeatures;

