import React from 'react';
import { Helmet } from 'react-helmet';

const WebHome = () => (
<>
<Helmet>
    <title>About Thought: Pioneering the Next Generation of Customer Interaction</title>
    <meta name="description" content="Discover Thought - a groundbreaking platform powered by Generative AI that is transforming the landscape of customer experience, setting new standards for business-consumer engagement." />
</Helmet>
        <div className="website-container">
            <center>
                <div className='content-container'>
                    {/* Introduction Section */}
                    <section className="main-section">
                        <h1>Building the future of Digital experience</h1>
                        <h3>Thought: Empowering Businesses and Customers</h3>
                        <div>
                            <p>
                                At Thought, we are reimagining the way businesses and customers communicate, connect, and thrive together. Our mission is to create a win-win platform where every interaction counts, leveraging the newest breakthroughs in technology.
                            </p>
                        </div>
                            <a href='/applications' className='buttonstyle'>Learn How it works?</a>

                    </section>
                    {/* Founder's Story Section */}
                    <section className="main-section">
                        <h1>Nandakumar's Thought</h1>
                        <div>
                            <p>
                                Born and raised in a quaint village, Nandakumar Somasundaram is an entrepreneur at heart and mind. Nandakumar has always been at the forefront of innovation. His journey with multiple startups over the years, reflects his commitment to creating impactful solutions.
                            </p>
                            <p>
                                The spark for "Thought" ignited while Nandakumar was in San Francisco in 2023. Combining his rich experience, a deep understanding of AI, and a vision for something revolutionary, he embarked on creating a platform that harmonizes business content, user context, generative AI, and third-party applications to deliver seamless customer experiences.
                            </p>
                        </div>
                        <h2>The Journey of Thought</h2>
                        <div>
                            <p>
                                From an idea to a fully functional platform, the journey of Thought is a testament to Nandakumar's perseverance and vision. Initially developed over a few months, the product garnered interest from potential customers and friends alike, intrigued by its innovative approach to customer engagement. Today, Thought stands as a testament to what can be achieved when passion meets innovation.
                            </p>
                            <p>
                                And here we are, with Thought, ready to change the world, one interaction at a time. Join us on this journey.
                            </p>
                        </div>
                        <section style={{ display: 'flex', flexWrap: 'wrap', justifyContent: 'center', padding: '0px', width:'100%' }}>
                <div className="image-container" style={{ flex: '1 1 auto', maxWidth: '340px', margin: '0px' }}>
                    <img src="/sfwork.jpg" alt="Description 1" style={{ width: '100%', height: 'auto' }} />
                </div>
                <div className="image-container" style={{ flex: '1 1 auto', maxWidth: '340px', margin: '0px' }}>
                    <img src="/sfwork2.jpg" alt="Description 2" style={{ width: '100%', height: 'auto' }} />
                </div>
                <div className="image-container" style={{ flex: '1 1 auto', maxWidth: '340px', margin: '0px' }}>
                    <img src="/sfwork3.jpg" alt="Description 3" style={{ width: '100%', height: 'auto' }} />
                </div>
                </section>

                    </section>
                </div>
            </center>
        </div>
    </>
);

export default WebHome;
