import React from 'react';
import { useNavigate } from 'react-router-dom';
import { Helmet } from 'react-helmet';

const AITeamsAssist = () => {
    const navigate = useNavigate();
    function handleClick() {
        navigate('/get-started');
    }

    return (
        <>
            <Helmet>
                <title>Empower Your Team with AI Assist | Thought AI</title>
                <meta name="description" content="Supercharge your team's productivity with Thought AI Assist. Integrate business docs, apps, social media, and more for a seamless workflow." />
            </Helmet>

            <div className="website-container">
                <center>
                <div className='content-container'>
                <section className="main-section">

                {/* Main Banner Section */}
                    <h1>Supercharge Your Workforce with AI-Powered Assistance</h1>
                    <p>Unlock the full potential of your team with Thought AI Assist. From documentation to daily tasks, integrate your entire digital workspace for an unparalleled efficiency boost.</p>
                    <button onClick={handleClick}>Activate AI Assist Today</button>

                </section>
                {/* Features Section */}
                <section className="features-section">
                    {/* Feature 1 */}
                    <div className="feature">
                        <div className="feature-content">
                            <h2><span className="material-symbols-outlined category-icon">workspace_premium</span> Comprehensive Integration: Your Digital Workspace Unified</h2>
                            <p>Thought AI Assist brings together your business content, from product documentation and files to social media and blog posts. With seamless integration of third-party applications, every piece of information is at your employees’ fingertips, empowering them with a full-time digital assistant.</p>
                        </div>
                    </div>

                    {/* Feature 2 */}
                    <div className="feature">
                        <div className="feature-content">
                            <h2><span className="material-symbols-outlined category-icon">chat_bubble_outline</span> Conversational Commands: Simplify Tasks with Chat</h2>
                            <p>Interact with your digital assistant using simple conversational commands. Thought AI Assist listens, understands, and executes tasks across your integrated platforms—whether it’s scheduling a meeting, updating a document, or posting on social media—all within the chat interface.</p>
                        </div>
                    </div>

                    {/* Feature 3 */}
                    <div className="feature">
                        <div className="feature-content">
                            <h2><span className="material-symbols-outlined category-icon">auto_awesome_mosaic</span> Streamlined Workflow: Enhance Productivity Effortlessly</h2>
                            <p>Automate routine tasks and streamline your workflow with AI. From compiling reports to managing email and beyond, Thought AI Assist works quietly in the background, ensuring that your team can focus on what matters most—innovation and creativity.</p>
                        </div>
                    </div>

                    {/* Feature 4 */}
                    <div className="feature">
                        <div className="feature-content">
                            <h2><span className="material-symbols-outlined category-icon">extension</span> Smart Integration: Do More with Your Apps</h2>
                            <p>Leverage the power of AI to interact with your favorite applications in new ways. Thought AI Assist not only integrates with these apps but also enhances them with smart features, such as predictive analytics and automated responses, transforming the way you work.</p>
                        </div>
                    </div>
                </section>
                </div>
                </center>
            </div>
        </>        
    );
};

export default AITeamsAssist;
