import React from 'react';
import { Routes, Route } from 'react-router-dom';

// Common Components
import WebLayout from '../Layouts/WebLayout';

// Direct imports for website routes
import WebHome from '../website/Home';
import WebContact from '../website/Contact';
import Pricing from '../pages/Billing/Pricing';
import Features from '../website/Features';
import Applications from '../website/Applications';
import WebHelp from '../website/Help';
import Terms from '../website/Terms';
import Privacy from '../website/Privacy';
import About from '../website/About';
import Interact from '../website/Interact';
import WebsiteChatbot from '../website/WebsiteChatbot';
import AIAssist from '../website/AIAssist';

const WebsiteRoutes = () => (
  <Routes>
    <Route path="/generativeai-team-assist" element={<WebLayout><AIAssist /></WebLayout>} />
    <Route path="/website-generativeai-chatbot" element={<WebLayout><WebsiteChatbot /></WebLayout>} />
    <Route path="/" element={<WebLayout><WebHome /></WebLayout>} />
    <Route path="/about" element={<WebLayout><About /></WebLayout>} />
    <Route path="/hello" element={<WebLayout><About /></WebLayout>} />
    <Route path="/contact" element={<WebLayout><WebContact /></WebLayout>} />
    <Route path="/how-it-works" element={<WebLayout><Features /></WebLayout>} />
    <Route path="/applications" element={<WebLayout><Applications /></WebLayout>} />
    <Route path="/pricing" element={<WebLayout><Pricing /></WebLayout>} />
    <Route path="/help" element={<WebLayout><WebHelp /></WebLayout>} />
    <Route path="/privacy" element={<WebLayout><Privacy /></WebLayout>} />
    <Route path="/terms" element={<WebLayout><Terms /></WebLayout>} />
    <Route path="/interact" element={<WebLayout><Interact /></WebLayout>} />
    {/* Add other routes as needed */}
  </Routes>
);

export default WebsiteRoutes;