// src/components/SaaSRoutes.js
import React from 'react';
import { Routes, Route } from 'react-router-dom';
import AdminLayout from '../Layouts/AdminLayout';
import AdminWrapper from '../../state/AdminWrapper';
import ProtectedRoute from './ProtectedRoute';
import { useFeatureMapping } from '../../state/useFeatureMapping';

import Adashboard from '../adminpages/Adashboard';
import Accounts from '../adminpages/Accounts';
import Partners from '../adminpages/Partners';
import Roles from '../adminpages/Roles';
import Users from '../adminpages/Users';
import Apps from '../adminpages/Apps';
import Subscriptions from '../adminpages/Subscriptions';
import Cities from '../adminpages/Cities';
import PricingType from '../adminpages/PricingType';
import VehicleCat from '../adminpages/VehicleCat';
import Setup from '../pages/Setup';
import ComingSoon from '../common/404';
import UnAuthorized from '../common/UnAuthorized';
import Inovices from '../adminpages/Invoices';
import Tickets from '../adminpages/Tickets';
import Billing from '../pages/Billing';
import SettingsPage from '../adminpages/Settings/SettingsPage';
import Invoices from '../adminpages/Invoices';
import SaaSPayments from '../adminpages/Subscriptions/Payments'


const SaaSRoutes = () => {
  const mapping = useFeatureMapping();

  return (
    <Routes>
      <Route path="/setup" element={<AdminWrapper><AdminLayout title="Setup"><Setup /></AdminLayout></AdminWrapper>} />
      <Route path="/saas/dash" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_dashboard} action="read"><AdminLayout title="Dashboard"><Adashboard featureId={mapping.saas_dashboard} /></AdminLayout></ProtectedRoute></AdminWrapper>} />
      <Route path="/saas/accounts" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_accounts} action="read"><AdminLayout title="Accounts"><Accounts featureId={mapping.saas_accounts} /></AdminLayout></ProtectedRoute></AdminWrapper>} />
      <Route path="/saas/partners" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_partners} action="read"><AdminLayout title="Partners"><Partners featureId={mapping.saas_partners} /></AdminLayout></ProtectedRoute></AdminWrapper>} />
      <Route path="/saas/roles" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_roles} action="read"><AdminLayout title="Roles"><Roles featureId={mapping.saas_roles} /></AdminLayout></ProtectedRoute></AdminWrapper>} />
      <Route path="/saas/users" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_users} action="read"><AdminLayout title="Users"><Users featureId={mapping.saas_users} /></AdminLayout></ProtectedRoute></AdminWrapper>} />
      <Route path="/saas/apps" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_apps} action="read"><AdminLayout title="Apps"><Apps featureId={mapping.saas_apps} /></AdminLayout></ProtectedRoute></AdminWrapper>} />
      <Route path="/saas/subscriptions" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_subscriptions} action="read"><AdminLayout title="Subscriptions"><Subscriptions featureId={mapping.saas_subscriptions} /></AdminLayout></ProtectedRoute></AdminWrapper>} />
      <Route path="/saas/invoices" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_invoices} action="read"><AdminLayout title="Invoices"><Invoices featureId={mapping.saas_invoices} /></AdminLayout></ProtectedRoute></AdminWrapper>} />
      <Route path="/saas/tickets" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_tickets} action="read"><AdminLayout title="Tickets"><Tickets featureId={mapping.saas_tickets} /></AdminLayout></ProtectedRoute></AdminWrapper>} />
      <Route path="/saas/settings/*" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_settings} action="read"><AdminLayout title="Settings"><SettingsPage /></AdminLayout></ProtectedRoute></AdminWrapper>} />
       <Route path="/saas/payments" element={<AdminWrapper><ProtectedRoute featureId={mapping.saas_tickets} action="read"><AdminLayout title="Payments"><SaaSPayments featureId={mapping.saas_tickets} /></AdminLayout></ProtectedRoute></AdminWrapper>} />


      <Route path="/saas/cities" element={<AdminWrapper><AdminLayout title="Cities"><Cities featureId={mapping.saas_cities} /></AdminLayout></AdminWrapper>} />
      <Route path="/saas/pricing" element={<AdminWrapper><AdminLayout title="Pricing"><PricingType featureId={mapping.saas_pricing} /></AdminLayout></AdminWrapper>} />
      <Route path="/saas/vehicle" element={<AdminWrapper><AdminLayout title="Pricing"><VehicleCat /></AdminLayout></AdminWrapper>} />
      <Route path="/unauthorized" element={<AdminWrapper><AdminLayout><UnAuthorized /></AdminLayout></AdminWrapper>} />
      <Route path="*" element={<AdminWrapper><AdminLayout><ComingSoon /></AdminLayout></AdminWrapper>} />
      <Route path="/billing/*" element={<AdminWrapper><AdminLayout title="Billing"><Billing /></AdminLayout></AdminWrapper>} />
    </Routes>
  );
};

export default SaaSRoutes;
