import React from 'react';
import { Navigate, useLocation } from 'react-router-dom';
import { useSelector } from 'react-redux';

const ProtectedRoute = ({ featureId, action, children }) => {
  const roleRights = useSelector((state) => state.rbac.roleRights);
  const location = useLocation();

  const currentUserRole = Number(localStorage.getItem('roles') || 100);

  const hasPermission = () => {
    const rights = roleRights?.[String(featureId)] || [];
    return rights.includes(action);
  };

  const isInitialRolesPage = location.pathname === '/saas/roles';
  const noRBACYet = !roleRights || Object.keys(roleRights).length === 0;

  // ✅ Allow /saas/roles only if:
  // - RBAC is not loaded
  // - AND user role === 1 (super admin)
  if (!hasPermission()) {
    if (noRBACYet && isInitialRolesPage && currentUserRole === 1) {
      return children;
    }
    return <Navigate to="/unauthorized" replace />;
  }

  return children;
};

export default ProtectedRoute;
