import React, { useEffect } from 'react';
import { Routes, Route } from 'react-router-dom';
import ProtectedRoute from './ProtectedRoute';
import { useFeatureMapping } from '../../state/useFeatureMapping';


import Layout from '../Layouts/Layout';
import AuthWrapper from '../../state/AuthWrapper';
import Dashboard from '../pages/Dashboard';
import Setup from '../pages/Setup';
import Billing from '../pages/Billing';
import Members from '../pages/Settings/Members';
import ComingSoon from '../common/404';
import Services from '../pages/Services';
import Workforce from '../pages/Workforce';
import PricingRules from '../pages/PricingRules';
import Vendors from '../pages/Vendors';
import Fleets from '../pages/Fleets';
import Customer from '../pages/Customer';
import Jobs from '../pages/Jobs';
import Schedules from '../pages/Schedule';
import Track from '../pages/Track';
import SettingsPage from '../pages/Settings/SettingsPage';
import VehicleTracking from '../common/VehicleTracking';
import Integrations from '../pages/Integrations'; // ✅ added this line
import Users from '../adminpages/Users'
import Dispatch from '../pages/Dispatch/Dispatch';
import DispatchNew from '../pages/Dispatch';





// 🔧 Reusable wrapper generator
const createWrappedPage = (Component, componentKey, shouldCollapse) => {
  return () => {
    useEffect(() => {
      if (window.menuControls) {
        window.menuControls.registerComponent(componentKey, {
          shouldHandleCollapse: shouldCollapse,
        });
      }
    }, []);
    return <Component />;
  };
};


// 🎯 Wrapped components
const TrackWrapper = createWrappedPage(Track, 'track', true);
const FleetsWrapper = createWrappedPage(Fleets, 'fleet', false);
const WorkforceWrapper = createWrappedPage(Workforce, 'workforce', false);
const ServicesWrapper = createWrappedPage(Services, 'services', false);
const SchedulesWrapper = createWrappedPage(Schedules, 'schedules', false);
const IntegrationsWrapper = createWrappedPage(Integrations, 'marketplace', false);
const UserWrapper = createWrappedPage (Users,'users',false);
const CustomerWrapper = createWrappedPage(Customer, 'customers', false);
const JobsWrapper = createWrappedPage(Jobs, 'tasks', false);
const DispatchWrapper = createWrappedPage(DispatchNew, 'dispatch', true);

 // Example with `false` (no collapse)


const PlatformRoutes = () => {
  const mapping = useFeatureMapping();


  return (
    <Routes>
      <Route path="/vendors" element={<AuthWrapper><Layout><Vendors /></Layout></AuthWrapper>} />
      <Route path="/fleet" element={<AuthWrapper><Layout><FleetsWrapper /></Layout></AuthWrapper>} />
      <Route path="/dash" element={<AuthWrapper><Layout><Dashboard /></Layout></AuthWrapper>} />
      <Route path="/services" element={<AuthWrapper><Layout><ServicesWrapper /></Layout></AuthWrapper>} />
      <Route path="/workforce" element={<AuthWrapper><Layout><WorkforceWrapper /></Layout></AuthWrapper>} />
      <Route path="/customers" element={<AuthWrapper><Layout><CustomerWrapper /></Layout></AuthWrapper>} />
      <Route path="/setup" element={<AuthWrapper><Layout><Setup /></Layout></AuthWrapper>} />
      <Route path="/saas/dash" element={<AuthWrapper><ProtectedRoute featureId={mapping.platform_dashboard} action="read"><Layout title="Dashboard"><Dashboard featureId={mapping.platform_dashboard} /></Layout></ProtectedRoute></AuthWrapper>} />
      <Route path="/billing/*" element={<AuthWrapper><Layout><Billing /></Layout></AuthWrapper>} />
      <Route path="/members" element={<AuthWrapper><Layout><Members /></Layout></AuthWrapper>} />
      <Route path="/jobs" element={<AuthWrapper><Layout><JobsWrapper /></Layout></AuthWrapper>} />
      <Route path="/schedules" element={<AuthWrapper><Layout><SchedulesWrapper /></Layout></AuthWrapper>} />
      <Route path="/track" element={<AuthWrapper><Layout><TrackWrapper /></Layout></AuthWrapper>} />
      <Route path="/settings" element={<AuthWrapper><Layout><SettingsPage /></Layout></AuthWrapper>} />
       <Route path="/marketplace" element={<AuthWrapper><Layout><IntegrationsWrapper /></Layout></AuthWrapper>} />
       <Route path="/users" element={<AuthWrapper><Layout><UserWrapper /></Layout></AuthWrapper>} />
       <Route path="/dispatch" element={<AuthWrapper><Layout><DispatchWrapper /></Layout></AuthWrapper>} />
      <Route path="*" element={<ComingSoon />} />
    </Routes>
  );
};


export default PlatformRoutes;