// src/components/CommonRoutes.js
import React from 'react';
import { Routes, Route } from 'react-router-dom';
import AuthLayout from '../Layouts/AuthLayout';
import Login from '../pages/Login';
import Logout from '../pages/Login/Logout';
import Signup from '../pages/Signup';
import Forgot from '../pages/Login/forgot';
import CreatePassword from '../pages/Signup/CreatePass';
import GoogleCallback from '../pages/Signup/GoogleCallBack';
import RedirectPage from '../common/Redirect';


const CommonRoutes = () => (
  <Routes>
    <Route path="/login" element={<AuthLayout><Login /></AuthLayout>} />
    <Route path="/logout" element={<AuthLayout><Logout /></AuthLayout>} />
    <Route path="/signup" element={<AuthLayout><Signup /></AuthLayout>} />
    <Route path="/google-callback" element={<AuthLayout><GoogleCallback /></AuthLayout>} />
    <Route path="/forgot-password" element={<AuthLayout><Forgot /></AuthLayout>} />
    <Route path="/verify" element={<AuthLayout><CreatePassword /></AuthLayout>} />
    <Route path="/r" element={<RedirectPage />} />    
    {/* Add additional common routes as needed */}
  </Routes>
);

export default CommonRoutes;
