import React from 'react';
import Tabs from '../../common/Tabs'; // Adjust the path as needed
import WorkforceCategoryList from './WorkforcecategoryList';
import NewWorkforcecategory from './AddWorkforcecategory';
import AddWorkforcecategory from './AddWorkforcecategory';

const WorkforceCategory = () => {
    const tabsData = [
        { id: 'workforce_list', label: 'Workforce List' },
        { id: 'new_workforce', label: 'New Workforce' },
        { id: 'category_list', label: 'Category List' },
        { id: 'new_category', label: 'New Category' },
    ];

    return (
        <div className="roles-container">
          
            <Tabs tabs={tabsData}>
                {(activeTab) => {
                    switch (activeTab) {
                        case 'workforce_list':
                            return <WorkforceCategoryList />;
                        case 'new_workforce':
                            return <NewWorkforcecategory />;
                        case 'category_list':
                            return <WorkforceCategoryList />;
                        case 'new_category':
                            return <AddWorkforcecategory />;
                        default:
                            return null;
                    }
                }}
            </Tabs>
        </div>
    );
};

export default WorkforceCategory;
