import React, { useState, useEffect } from 'react';
import axios from 'axios';
import WorkforcecategoryForm from './WorkforcecategoryForm';
import Modal from '../../Layouts/Modal';

const WorkforceCategoryUpdate = ({ workforceCategoryId, onClose, onUpdateSuccess }) => {
    const [workforceCategoryData, setWorkforceCategoryData] = useState(null);
    const [loading, setLoading] = useState(true);
    const [error, setError] = useState('');

    useEffect(() => {
        axios.get(`/workforcecategory/${workforceCategoryId}`)
            .then(res => {
                // Ensure the data matches the schema exactly
                const formattedData = {
                    category_name: res.data.category_name,
                    description: res.data.description,
                    shift_hours: Number(res.data.shift_hours),
                    capacity_jobs: Number(res.data.capacity_jobs)
                };
                setWorkforceCategoryData(formattedData);
                setLoading(false);
            })
            .catch(err => {
                setError('Error fetching workforce category data.');
                setLoading(false);
                console.error('Error fetching data:', err);
            });
    }, [workforceCategoryId]);

    const handleSubmit = (formData) => {
        // Add static account_id and user_id similar to the create operation
        const payload = {
            ...formData,
            account_id: localStorage.getItem('account_id'),
        user_id: localStorage.getItem('user_id'),
        };

        axios.put(`/workforcecategory/${workforceCategoryId}`, payload)
            .then(res => {
                alert("Workforce category updated successfully!");
                if (onUpdateSuccess) onUpdateSuccess(res.data);
                onClose();
            })
            .catch(err => {
                alert("Error updating workforce category.");
                console.error('Update error:', err.response?.data || err.message);
            });
    };

    return (
        <Modal title="Edit Workforce Category" onClose={onClose}>
            {loading ? (
                <div>Loading workforce category data...</div>
            ) : error ? (
                <div style={{ color: 'red' }}>{error}</div>
            ) : (
                <WorkforcecategoryForm 
                    initialData={workforceCategoryData} 
                    onSubmit={handleSubmit} 
                />
            )}
        </Modal>
    );
};

export default WorkforceCategoryUpdate;