import React, { useEffect, useState } from 'react';
import Form from '@rjsf/core';
import validator from '@rjsf/validator-ajv8';

const workforceCategorySchema = {
  
  type: "object",
  required: ["category_name", "description", "shift_hours", "capacity_jobs"],
  properties: {
    category_name: { type: "string", title: "Category Name", default: "" },
    description: { type: "string", title: "Description", default: "" },
    shift_hours: { type: "number", title: "Shift Hours", default: 0 },
    capacity_jobs: { type: "number", title: "Capacity Jobs", default: 1 }
  }
};

const uiSchema = {
  category_name: {
    "ui:placeholder": "Enter category name",
    "ui:options": { classNames: "boxed-input" }
  },
  description: {
    "ui:widget": "textarea",
    "ui:placeholder": "Enter description",
    "ui:options": { classNames: "boxed-input" }
  },
  shift_hours: {
    "ui:placeholder": "Enter hours",
    "ui:widget": "updown",
    "ui:options": { classNames: "boxed-input" }
  },
  capacity_jobs: {
    "ui:placeholder": "Enter capacity (minimum 1)",
    "ui:widget": "updown",
    "ui:options": { classNames: "boxed-input" }
  }
};

const transformErrors = () => [];

const WorkforceCategoryForm = ({ initialData, onSubmit }) => {
  const [formData, setFormData] = useState(initialData || {});

  useEffect(() => {
    if (initialData) {
      setFormData(initialData);
    }
  }, [initialData]);

  useEffect(() => {
    const style = document.createElement("style");
    style.innerHTML = `
      .boxed-input input,
      .boxed-input select,
      .boxed-input textarea {
        border: 1px solid #ccc;
        border-radius: 4px;
        padding: 10px;
        background-color: #fff;
        box-shadow: none;
        width: 100%;
        font-size: 14px;
      }

      .boxed-input input:focus,
      .boxed-input select:focus,
      .boxed-input textarea:focus {
        border-color: #000;
        outline: none;
      }

      .boxed-input label {
        font-weight: 500;
        margin-bottom: 6px;
        display: block;
      }

      .errors,
      .field .errors,
      .error-detail,
      .rjsf .alert-danger {
        display: none !important;
      }

      button[type="submit"] {
        background-color:#f0f0f0;
        color: #00c853;
        padding: 10px 20px;
        font-weight: bold;
        border: 1px solid #white;
        border-radius: 4px;
        cursor: pointer;
        margin-top: 20px;
        transition: all 0.3s ease;
        font-size: 14px;
      }

      button[type="submit"]:hover {
        background-color: #00c853;
        color: white;
        border-color: #00c853;
      }
    `;
    document.head.appendChild(style);
    return () => document.head.removeChild(style);
  }, []);

  const handleSubmit = ({ formData }) => {
    onSubmit(formData);
  };

  return (
    <div style={{ maxWidth: "600px", marginLeft: "0", paddingLeft: "20px" }}>
      <Form
        schema={workforceCategorySchema}
        uiSchema={uiSchema}
        formData={formData}
        onChange={({ formData }) => setFormData(formData)}
        onSubmit={handleSubmit}
        validator={validator}
        transformErrors={transformErrors}
        showErrorList={false}
        liveValidate
      />
    </div>
  );
};

export default WorkforceCategoryForm;










