import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const WorkforceCategoryDB = ({ workforceCategoryId, onClose, onDeleteSuccess }) => {
    const [isSubmitting, setSubmitting] = useState(false);
    const [error, setError] = useState('');

    const deleteWorkforceCategory = () => {
        if (isSubmitting) return;
        setSubmitting(true);
        axios.delete(`/workforcecategory/${workforceCategoryId}`)
            .then(res => {
                alert("Workforce category deleted successfully.");
                if (onDeleteSuccess) onDeleteSuccess();
                onClose();
            })
            .catch(err => {
                setError("Error deleting workforce category.");
            })
            .finally(() => {
                setSubmitting(false);
            });
    };

    return (
        <Modal title="Delete Workforce Category" onClose={onClose}>
            {error && <p style={{ color: 'red' }}>{error}</p>}
            <p>Are you sure you want to delete or block this workforce category?</p>

            {/* Added a flex container to properly align both buttons */}
            <div style={{ display: 'flex', gap: '20px' }}>
                <button onClick={deleteWorkforceCategory} disabled={isSubmitting}>Confirm</button>

                {/* Shifted the Cancel button slightly right using marginLeft */}
                <button 
                    onClick={onClose} 
                    style={{ marginLeft: '5px' }} // <-- Added this line to shift right
                >
                    Cancel
                </button>
            </div>
        </Modal>
    );
};

export default WorkforceCategoryDB;
