import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import WorkforceCategoryForm from './WorkforcecategoryForm';

const NewWorkforcecategory = ({ onClose, onCreateSuccess }) => {
    const handleSubmit = (formData) => {
        // Static account_id and user_id
        const account_id =  localStorage.getItem('account_id'); 
        const user_id =localStorage.getItem('user_id');

        

        // Add account_id and user_id to the payload
        const payload = {
            ...formData,
            account_id, // Static account_id
            user_id // Static user_id
        };

        console.log("Payload:", payload); // Debug the payload

        axios.post(`/workforcecategory/`, payload)
            .then(res => {
                alert("Workforce category created successfully!");
                if (onCreateSuccess) onCreateSuccess(res.data);
                if (onClose) onClose();
            })
            .catch(err => {
                alert("Error creating Workforce category.");
                console.error(err);  // Log the error for debugging
            });
    };

    return (
        <div>
            <WorkforceCategoryForm onSubmit={handleSubmit} />
        </div>
    );
};

export default NewWorkforcecategory;





