import React from 'react';
import Tabs from '../../common/Tabs'; // Adjust the path as needed
import { useNavigate } from 'react-router-dom';
import WorkforceList from './WorkforceList';
import NewWorkforce from './AddWorkforce';
import WorkforceCategoryList from '../Workforcecategory/WorkforcecategoryList';
import NewWorkforcecategory from '../Workforcecategory/AddWorkforcecategory';

const Workforce = () => {
    const name = localStorage.getItem('name') || 'Unknown';
    const roles = localStorage.getItem('roles') || '-1';
    const navigate = useNavigate();

    const tabsData = [
        { id: 'workforce_list', label: 'Workforces' },
        { id: 'new_workforce', label: 'Add' },
        { id: 'category_list', label: 'Workforce Categorys' },
        { id: 'new_category', label: 'Add' },
    ];

    return (
        <div className="roles-container">
          
            <Tabs tabs={tabsData}>
                {(activeTab) => {
                    switch (activeTab) {
                        case 'workforce_list':
                            return <WorkforceList />;
                        case 'new_workforce':
                            return <NewWorkforce />;
                        case 'category_list':
                            return <WorkforceCategoryList />;
                        case 'new_category':
                            return <NewWorkforcecategory />;
                        default:
                            return null;
                    }
                }}
            </Tabs>
        </div>
    );
};

export default Workforce;