import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const WorkforceDB = ({ workforceId, onClose, onDeleteSuccess }) => {
    const [isSubmitting, setSubmitting] = useState(false);
    const [error, setError] = useState('');

    const deleteWorkforce = () => {
        setSubmitting(true);
        axios.delete(`/workforce/${workforceId}`)
            .then(() => {
                alert("Workforce deleted successfully.");
                onDeleteSuccess?.();
                onClose?.();
            })
            .catch(err => setError("Error deleting workforce."))
            .finally(() => setSubmitting(false));
    };

return (
  <Modal title="Delete Workforce" onClose={onClose}>
    {error && <p className="error">{error}</p>}
    <p>Are you sure you want to delete or block this workforce?</p>

    <div style={{ display: 'flex', gap: '10px', marginTop: '16px' }}>
      <button onClick={deleteWorkforce} disabled={isSubmitting}>
        {isSubmitting ? 'Deleting...' : 'Confirm'}
      </button>
      <button onClick={onClose}>Cancel</button>
    </div>
  </Modal>
);
};

export default WorkforceDB;