import React from 'react';
import Tabs from '../../common/Tabs';
import VendorsList from './VendorList';
import NewVendor from './AddVendor';

const Vendors = () => {
  const tabsData = [
    { id: 'list', label: 'Vendors' },
    { id: 'new', label: 'Add' }
  ];

  const tabComponents = {
    list: <VendorsList />,
    new: <NewVendor />
  };

  return (
    <div className="vendors-container">
    
      <Tabs tabs={tabsData}>
        {(activeTab) => tabComponents[activeTab] || null}
      </Tabs>
    </div>
  );
};

export default Vendors;
