import React, { useState, useEffect } from 'react';
import axios from 'axios';
import VendorForm from './VendorForm';
import Modal from '../../Layouts/Modal';

const VendorUpdate = ({ vendorId, onClose, onUpdateSuccess }) => {
  const [vendorData, setVendorData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');

  useEffect(() => {
    axios.get(`/vendors/${vendorId}`)
      .then(res => {
        setVendorData(res.data);
        setLoading(false);
      })
      .catch(err => {
        setError("Error fetching vendor data");
        setLoading(false);
      });
  }, [vendorId]);

  const handleSubmit = (formData) => {
    axios.put(`/vendors/${vendorId}`, formData)
      .then(res => {
        alert("Vendor updated successfully!");
        if (onUpdateSuccess) onUpdateSuccess(res.data);
        onClose();
      })
      .catch(err => {
        alert("Error updating vendor");
      });
  };

  return (
    <Modal title="Edit Vendor" onClose={onClose}>
      {loading ? (
        <div>Loading vendor data...</div>
      ) : error ? (
        <div style={{ color: 'red' }}>{error}</div>
      ) : (
        <VendorForm initialData={vendorData} onSubmit={handleSubmit} />
      )}
    </Modal>
  );
};

export default VendorUpdate;