import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const VendorDelete = ({ vendorId, onClose, onDeleteSuccess }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deleteVendor = () => {
    if (isSubmitting) return;
    setSubmitting(true);
    
    axios.delete(`/vendors/${vendorId}`)
      .then(res => {
        alert("Vendor deleted successfully!");
        if (onDeleteSuccess) onDeleteSuccess();
        onClose();
      })
      .catch(err => {
        setError("Error deleting vendor");
      })
      .finally(() => {
        setSubmitting(false);
      });
  };

  return (
    <Modal title="Delete Vendor" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete this vendor?</p>
      <div style={{ display: 'flex', gap: '10px', marginTop: '15px' }}>
        <button onClick={deleteVendor} disabled={isSubmitting}>Confirm</button>
        <button onClick={onClose}>Cancel</button>
      </div>
    </Modal>
  );
};

export default VendorDelete;