


import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import VendorForm from './VendorForm';

const NewVendor = ({ onClose, onCreateSuccess }) => {
  const handleSubmit = (formData) => {
    axios.post(`/vendors/`, formData)
      .then(res => {
        alert("Vendor created successfully!");
        onCreateSuccess?.(res.data); // Optional chaining
        onClose?.(); // Optional chaining
      })
      .catch(err => {
        alert("Error creating vendor");
        console.error("Creation error:", err);
      });
  };

  return (
    // <Modal 
    //   title="New Vendor" 
    //   onClose={onClose}
    //   closeOnClickOutside={true} // Add this if your Modal supports it
    // >
    <div>
      <VendorForm onSubmit={handleSubmit} />
    </div>
  );
};

export default NewVendor;



