import React, { useState } from 'react';
import Tabs from '../../common/Tabs';
import IoTDevices from '../IOTDevice';
import Geofence from '../GeoFences';
import GeoFencingRules from '../GeoFencingRules';
import GeoFencingRulesMapping from '../GeoFencingRulesMapping';
import TrackView from './Track';
import VehicleTracking from '../../common/VehicleTracking';

const Track = () => {
  const [showTabs, setShowTabs] = useState(false);
  const tabsData = [
    { id: 'track', label: 'Track' },
    { id: 'iot', label: 'IOT Device' },
    { id: 'geofencing', label: 'Geofencing' },
    { id: 'geofencingrules', label: 'Rules' },
    { id: 'geofencingrulesmapping', label: 'Mapping' },
  ];

  return (
    <div className="roles-container">
      {showTabs ? (
        <Tabs tabs={tabsData}>
          {(activeTab) => {
            switch (activeTab) {
              case 'track':
                return <TrackView setShowTabs={setShowTabs} />;
              case 'iot':
                return <IoTDevices />;
              case 'geofencing':
                return <Geofence />;
              case 'geofencingrules':
                return <GeoFencingRules />;
              case 'geofencingrulesmapping':
                return <GeoFencingRulesMapping />;
                
              default:
                return null;
            }
          }}
        </Tabs>
      ) : (
        <TrackView setShowTabs={setShowTabs} />
      )}
    </div>
  );
};

export default Track;