


import React, { useState, useEffect } from 'react';
import { useNavigate, Link } from 'react-router-dom';
import axios from 'axios';
import GoogleSignIn from '../Signup/GoogleSignIn';

const Signup = () => {
  const [email, setEmail] = useState('');
  const [errorMessage, setErrorMessage] = useState('');
  const [isSubmitting, setIsSubmitting] = useState(false);
  const navigate = useNavigate();
  
  useEffect(() => {
    if (localStorage.getItem('user_id')) {
      navigate('/dash');
    }
  }, [navigate]);

  const isValidEmail = () => /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/.test(email);

  const handleContinue = async () => {
    if (isSubmitting) return;
    if (!isValidEmail()) return setErrorMessage('Your email is invalid!!');
    
    setErrorMessage('');
    setIsSubmitting(true);
    
    try {
      const { data } = await axios.post('/users/emailverification/', {
        emails: email,
        action: 'signup'
      });
      if (data.status === 1) {
        setErrorMessage('User already exists. Please use login to access your account.');
      } else if (data.status === 3) {
        navigate('/verify', { 
          state: { email } // Ensure email is passed in state
        });
      }
    } catch (error) {
      console.error('Error during email validation:', error);
      setErrorMessage('Error during email validation.');
    } finally {
      setIsSubmitting(false);
    }
  };

  return (
    <div className="container">
      <h2>Welcome Aboard!</h2>
      <p className="note">
        We're thrilled to have you join our community dedicated to moving people, goods and services. Let's get started!
      </p>
      <input
        type="email"
        placeholder="Email address"
        value={email}
        onChange={(e) => setEmail(e.target.value)}
        className="input"
      />
      {errorMessage && <p className="error">{errorMessage}</p>}
      <br />
      <button onClick={handleContinue} className="button" disabled={isSubmitting}>
        {isSubmitting ? 'Signing up...' : 'Signup'}
      </button>
      <p>
        Already have an account? <Link to="/login">Login here</Link>
      </p>
      <div className="orContainer">
        <div className="line"></div>
        <p className="orText">OR</p>
        <div className="line"></div>
      </div>
      <GoogleSignIn />
      <p>
        Our <Link to="/terms">Terms of Service</Link> and <Link to="/privacy">Privacy Policy</Link>
      </p>
    </div>
  );
};

export default Signup;