import React, { useState, useEffect } from 'react';

const GoogleCallback = () => {
    useEffect(() => {
        const urlParams = new URLSearchParams(window.location.search);
        const code = urlParams.get('code');

        if (code) {
            // Send this code back to the parent window (your React app)
            window.opener.postMessage({ code }, window.location.origin);
        }

        // Close the popup
        window.close();
    }, []);

    return <div>Loading...</div>;
};

export default GoogleCallback;
