import React, { useState } from 'react';
import SearchPage from '../../common/SearchPage';
import List from '../../common/List';
import UserModal from '../Dashboard/Setup';
import InviteUserModal from '../../common/Modal/InviteUser';
import DeleteUserModal from '../../common/Modal/DeleteUser';

const USERS_HEADER_TO_KEY_MAP = {
  "User Name": "name",
  "Email": "email",
  "Mobile": "mobile",
  "Roles": "roles",
  "Date": "created_date",
  "Status": "is_active",
};

const UsersList = ({ initialSearchQuery = '', rowsPerPage = 10 }) => {
  const roles = localStorage.getItem('roles');
  const accountId = localStorage.getItem('account_id');

  var fetchDataUrl = `/users/list/${accountId}/`;

  const [selectedUserId, setSelectedUserId] = useState(null);
  const [isInviteModalOpen, setIsInviteModalOpen] = useState(false);
  const [actionType, setActionType] = useState(null); // new state to track action type

  const actionFormats = [
    { label: "view", modal: true,  url: "/users/view/{id}" },
    { label: "delete",modal: true,  url: "/users/delete/{id}" }
  ];
  
  
  // POPUP
  const handleActionClick = (user_id, action) => {
    setSelectedUserId(user_id);
    setActionType(action.label);
  };
  
  // Function to close any modal
  const closeModal = () => {
    setSelectedUserId(null);
    setIsInviteModalOpen(false);
    setActionType(null);
  };

  const tabsData = [
    { id: 'members', label: 'Members' },
    { id: 'new', label: '+ Invite' }
  ];

  // Function to handle tab click
  const handleTabClick = (tabId, e) => {
    e.preventDefault();
    if (tabId === 'new') {
      setIsInviteModalOpen(true);
    }
  };

    // Render the appropriate modal based on the action type
    const renderModal = () => {
      //console.log("user ID ", selectedUserId);
      if(actionType){
      switch (actionType) {
        case 'view':
          return <UserModal userId={selectedUserId} onClose={closeModal} />;
        case 'delete':
          return <DeleteUserModal userId={selectedUserId} onClose={closeModal} />;
        default:
          break;
      }
    }
    };
  

  return (
    <div>
      <div className="tabs-container">
        <div className="tab-links">
          <a 
              href="#" 
              onClick={(e) => handleTabClick('members', e)}
              className={'activated'} // Members tab always active
          >
              Users
          </a>
          <a 
              href="#" 
              onClick={(e) => handleTabClick('new', e)}
          >
              + Invite
          </a>
        </div>
      </div>

      <SearchPage
        fetchDataUrl={fetchDataUrl}
        ListComponent={List}
        itemKeyMapping={USERS_HEADER_TO_KEY_MAP}
        dataKey="users"
        identifierKey="user_id"
        initialSearchQuery={initialSearchQuery}
        rowsPerPage={rowsPerPage}
        actionFormats={actionFormats}
        onActionClick={handleActionClick}
      />
      {renderModal()}

      {isInviteModalOpen && (
        <InviteUserModal onClose={() => setIsInviteModalOpen(false)} />
      )}
    </div>     
  );
}

export default UsersList;
