import React, { useState, useEffect } from 'react';
import { Button, Grid, Typography, FormControlLabel, Switch, Divider } from '@mui/material';

const DisplaySettings = ({ data, onSave }) => {
  const [settings, setSettings] = useState({
    show_map: true,  // ✅ Changed from showMap to show_map
    pagination: 10    // ✅ Changed from itemsPerPage to pagination
  });

  useEffect(() => {
    if (data.display) {
      const { showMap, itemsPerPage } = data.display;
      setSettings({ 
        show_map: showMap,       // ✅ Changed property name
        pagination: itemsPerPage  // ✅ Changed property name
      });
    }
  }, [data]);

  const handleChange = (event) => {
    const { name, value, type, checked } = event.target;
    setSettings({
      ...settings,
      [name]: type === 'checkbox' ? checked : value,
    });
  };

  const handleSubmit = () => {
    onSave('ui', settings);
  };

  return (
    <div className="settings-container">
      <Typography variant="subtitle1" gutterBottom className="settings-section-title">
        <span className="material-symbols-outlined settings-icon">visibility</span>
        Display Settings
      </Typography>

      <Grid container spacing={2} sx={{ mb: 3 }}>
        <Grid item xs={12}>
          <FormControlLabel
            control={
              <Switch
                checked={settings.show_map}  // ✅ Changed from showMap to show_map
                onChange={handleChange}
                name="show_map"              // ✅ Changed from showMap to show_map
                sx={{
                  '& .MuiSwitch-switchBase.Mui-checked': {
                    color: '#4CAF50',
                  },
                  '& .MuiSwitch-switchBase.Mui-checked + .MuiSwitch-track': {
                    backgroundColor: '#4CAF50',
                  }
                }}
              />
            }
            label={<span className="settings-label">Show Map in Dashboard</span>}
          />
        </Grid>
      </Grid>

      <Divider className="settings-divider" />

      <Typography variant="subtitle1" gutterBottom className="settings-section-title">
        <span className="material-symbols-outlined settings-icon">table_rows</span>
        UI Preferences
      </Typography>

      <Grid container spacing={2} sx={{ mb: 3 }}>
        <Grid item xs={12} sm={6}>
          <label className="settings-label">Items per page</label>
          <input
            className="settings-input"
            type="number"
            name="pagination"          // ✅ Changed from itemsPerPage to pagination
            value={settings.pagination} // ✅ Changed from itemsPerPage to pagination
            onChange={handleChange}
            min={5}
            max={100}
          />
        </Grid>
      </Grid>

      <Button
        variant="contained"
        onClick={handleSubmit}
        sx={{
          backgroundColor: '#4CAF50',
          '&:hover': {
            backgroundColor: '#45A049'
          },
          color: '#fff',
          textTransform: 'none'
        }}
      >
        save changes
      </Button>
    </div>
  );
};

export default DisplaySettings;