import React, { useState, useEffect } from 'react';
import {
  Button,
  Grid,
  Typography,
  FormControlLabel,
  RadioGroup,
  Radio
} from '@mui/material';
import DirectionsCarIcon from '@mui/icons-material/DirectionsCar';
import LocationOnIcon from '@mui/icons-material/LocationOn';

const AvailabilitySettings = ({ data, onSave }) => {
  const [trackBy, setTrackBy] = useState('km');
  const [availabilityRange, setAvailabilityRange] = useState(50);
  const [trackingMode, setTrackingMode] = useState('always');

  useEffect(() => {
    if (data.availability) {
      setTrackBy(data.availability.track_by || 'km');
      setAvailabilityRange(data.availability.range || 50);
      setTrackingMode(data.availability.tracking_mode || 'always');
    }
  }, [data]);

  const handleSubmit = () => {
    onSave('availability', {
      track_by: trackBy,
      distance_range_km: availabilityRange,
      tracking_mode: trackingMode
    });
  };

  return (
    <div className="settings-container">
      <Typography variant="subtitle1" gutterBottom className="settings-section-title">
        <span className="material-symbols-outlined settings-icon">
          directions_car
        </span>
        Tracking Units
      </Typography>

      <Grid container spacing={2} sx={{ mb: 3 }}>
        <Grid item xs={12}>
          <RadioGroup
            row
            value={trackBy}
            onChange={(e) => setTrackBy(e.target.value)}
          >
            <FormControlLabel
              value="km"
              control={<Radio sx={{ color: '#4CAF50', '&.Mui-checked': { color: '#4CAF50' } }} />}
              label={<Typography className="settings-label">Kilometers</Typography>}
            />
            <FormControlLabel
              value="mile"
              control={<Radio sx={{ color: '#4CAF50', '&.Mui-checked': { color: '#4CAF50' } }} />}
              label={<Typography className="settings-label">Miles</Typography>}
            />
          </RadioGroup>
        </Grid>
      </Grid>

      <Typography variant="subtitle1" gutterBottom className="settings-section-title">
        <span className="material-symbols-outlined settings-icon">
          location_on
        </span>
        Driver Availability
      </Typography>

      <Grid container spacing={2} sx={{ mb: 3 }}>
        <Grid item xs={12}>
          <Typography className="settings-label">
            Driver Availability Range: {availabilityRange} {trackBy === 'km' ? 'km' : 'miles'}
          </Typography>
          <input
            type="range"
            min="10"
            max="200"
            value={availabilityRange}
            onChange={(e) => setAvailabilityRange(e.target.value)}
            className="settings-input"
            style={{
              width: '100%',
              accentColor: '#4CAF50'  // green slider
            }}
          />
        </Grid>
      </Grid>

      <Typography variant="subtitle1" gutterBottom className="settings-section-title">
        Tracking Mode
      </Typography>
      <Grid container spacing={2} sx={{ mb: 3 }}>
        <Grid item xs={12}>
          <RadioGroup
            value={trackingMode}
            onChange={(e) => setTrackingMode(e.target.value)}
          >
            <FormControlLabel
              value="always"
              control={<Radio sx={{ color: '#4CAF50', '&.Mui-checked': { color: '#4CAF50' } }} />}
              label={<Typography className="settings-label">Always track driver location</Typography>}
            />
            <FormControlLabel
              value="active_jobs"
              control={<Radio sx={{ color: '#4CAF50', '&.Mui-checked': { color: '#4CAF50' } }} />}
              label={<Typography className="settings-label">Track only during active jobs</Typography>}
            />
          </RadioGroup>
        </Grid>
      </Grid>

<Button
        variant="contained"
        onClick={handleSubmit}
        // ✅ Changed button color from blue to green using the sx prop
        sx={{
          backgroundColor: '#4CAF50', // Green color
          '&:hover': {
            backgroundColor: '#45A049'
          },
          color: '#fff',
          textTransform: 'none'
        }}
      >
        save changes
      </Button>
    </div>
  );
};

export default AvailabilitySettings;
