import React, { useState, useEffect } from 'react';
import { Grid, Typography, Divider, Button } from '@mui/material';

// Dummy links for testing
const DUMMY_LINKS = {
  android_customer: "https://play.google.com/store/apps/details?id=com.company.customerapp",
  ios_customer: "https://apps.apple.com/us/app/company-customer-app/id1234567890",
  android_workforce: "https://play.google.com/store/apps/details?id=com.company.workforceapp",
  ios_workforce: "https://apps.apple.com/us/app/company-workforce-app/id9876543210",
  social_redirect_facebook: "https://www.facebook.com/CompanyPage/",
  social_redirect_twitter: "https://twitter.com/CompanyHandle",
  social_redirect_instagram: "https://www.instagram.com/companyprofile/"
};

const AppLinksSettings = ({ data, onSave }) => {
  const [links, setLinks] = useState(DUMMY_LINKS); // Initialize with dummy data

  useEffect(() => {
    if (data?.appLinks) {
      // Safely transform incoming data
      setLinks({
        android_customer: data.appLinks.android_customer || DUMMY_LINKS.android_customer,
        ios_customer: data.appLinks.ios_customer || DUMMY_LINKS.ios_customer,
        android_workforce: data.appLinks.android_workforce || DUMMY_LINKS.android_workforce,
        ios_workforce: data.appLinks.ios_workforce || DUMMY_LINKS.ios_workforce,
        social_redirect_facebook: data.appLinks.social_redirect_facebook || DUMMY_LINKS.social_redirect_facebook,
        social_redirect_twitter: data.appLinks.social_redirect_twitter || DUMMY_LINKS.social_redirect_twitter,
        social_redirect_instagram: data.appLinks.social_redirect_instagram || DUMMY_LINKS.social_redirect_instagram
      });
    }
  }, [data]);

  const handleChange = (event) => {
    const { name, value } = event.target;
    setLinks(prev => ({
      ...prev,
      [name]: value
    }));
  };

  const handleSubmit = () => {
    onSave('appLinks', links);
  };

  return (
    <div className="settings-container">
      {/* Customer App Links */}
      <Typography variant="h6" gutterBottom className="settings-section-title">
        <span className="material-symbols-outlined settings-icon">android</span>
        Customer App Links
      </Typography>

      <Grid container spacing={2} sx={{ marginBottom: 3 }}>
        <Grid item xs={12} sm={6}>
          <label className="settings-label">Android App Link</label>
          <input
            className="settings-input"
            type="url"
            name="android_customer"
            value={links.android_customer}
            onChange={handleChange}
            placeholder="Enter Android app URL"
          />
        </Grid>
        <Grid item xs={12} sm={6}>
          <label className="settings-label">iOS App Link</label>
          <input
            className="settings-input"
            type="url"
            name="ios_customer"
            value={links.ios_customer}
            onChange={handleChange}
            placeholder="Enter iOS app URL"
          />
        </Grid>
      </Grid>

      <Divider className="settings-divider" />

      {/* Workforce App Links */}
      <Typography variant="h6" gutterBottom className="settings-section-title">
        <span className="material-symbols-outlined settings-icon">android</span>
        Workforce App Links
      </Typography>

      <Grid container spacing={2} sx={{ marginBottom: 3 }}>
        <Grid item xs={12} sm={6}>
          <label className="settings-label">Android App Link</label>
          <input
            className="settings-input"
            type="url"
            name="android_workforce"
            value={links.android_workforce}
            onChange={handleChange}
            placeholder="Enter Android app URL"
          />
        </Grid>
        <Grid item xs={12} sm={6}>
          <label className="settings-label">iOS App Link</label>
          <input
            className="settings-input"
            type="url"
            name="ios_workforce"
            value={links.ios_workforce}
            onChange={handleChange}
            placeholder="Enter iOS app URL"
          />
        </Grid>
      </Grid>

      <Divider className="settings-divider" />

      {/* Social Media Links */}
      <Typography variant="h6" gutterBottom className="settings-section-title">
        <span className="material-symbols-outlined settings-icon">share</span>
        Social Media Links
      </Typography>

      <Grid container spacing={2} sx={{ marginBottom: 3 }}>
        <Grid item xs={12} sm={4}>
          <label className="settings-label">Facebook Page</label>
          <input
            className="settings-input"
            type="url"
            name="social_redirect_facebook"
            value={links.social_redirect_facebook}
            onChange={handleChange}
            placeholder="Enter Facebook URL"
          />
        </Grid>
        <Grid item xs={12} sm={4}>
          <label className="settings-label">Twitter Profile</label>
          <input
            className="settings-input"
            type="url"
            name="social_redirect_twitter"
            value={links.social_redirect_twitter}
            onChange={handleChange}
            placeholder="Enter Twitter URL"
          />
        </Grid>
        <Grid item xs={12} sm={4}>
          <label className="settings-label">Instagram Profile</label>
          <input
            className="settings-input"
            type="url"
            name="social_redirect_instagram"
            value={links.social_redirect_instagram}
            onChange={handleChange}
            placeholder="Enter Instagram URL"
          />
        </Grid>
      </Grid>

      <Button
        variant="contained"
        onClick={handleSubmit}
        sx={{
          backgroundColor: '#4CAF50',
          '&:hover': { backgroundColor: '#45A049' },
          color: '#fff',
          textTransform: 'none',
          padding: '8px 24px',
          fontSize: '1rem'
        }}
      >
        Save Changes
      </Button>
    </div>
  );
};

export default AppLinksSettings;