import React, { useState } from 'react';
import Tabs from '../../common/Tabs'; // Adjust the path as needed
import PricingType from '../../adminpages/PricingType';
import PricingRules from '../PricingRules';
import Service from '../Service';
import Skills from '../../adminpages/Skills';
import Checklist from '../../adminpages/Checklist';
import Addons from '../../adminpages/Addons';




const Services = () => {
  const tabsData = [
    { id: 'list', label: 'Services' },
  
    { id: 'pricingruleslist', label: 'Pricing Rules' },
    
    { id: 'pricintypeslist', label: 'Pricing Types' },

    { id: 'skillslist', label: 'Skills' },

    { id: 'checklist', label: 'Checklist' },

    { id: 'addonslist', label: 'Addons' },
  ];

  return (
    <div className="roles-container">
    
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'list':
              return <Service />;
            
              case'pricingruleslist':
              return<PricingRules/>;
            
            case 'pricintypeslist':
              return <PricingType />;

              case 'skillslist':
                return <Skills/>;

                case 'checklist':
                  
                  return<Checklist/>;

                  case 'addonslist':
                    return<Addons/>;
            
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Services;
