import React, { useState } from 'react';
import Tabs from '../../common/Tabs'; // Adjust the path as needed
import ServicesList from './ServicesList';
import NewServices from './AddServices';



const Service = () => {
  const tabsData = [
    { id: 'list', label: 'List' },
    { id: 'new', label: 'Add' },
  ];

  return (
    <div className="roles-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'list':
              return <ServicesList />;
            
            case 'new':
              return <NewServices />;
            
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Service;
