import React, { useState, useEffect } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import CommonTaskList from '../../common/CommonTaskList';


const TAB_CONFIG = [
  { id: 'overview', label: 'Overview', icon: 'info' },
  { id: 'tasks', label: 'Tasks', icon: 'assignment' },
  { id: 'usage', label: 'Usage', icon: 'trending_up' },
  // { id: 'settings', label: 'Settings', icon: 'settings' }
];


const ServicesView = ({ userId, onClose }) => {
  const [userData, setUserData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');
  const [activeTab, setActiveTab] = useState('overview');
  const [hoveredTab, setHoveredTab] = useState(null);


  useEffect(() => {
    axios.get(`/services/${userId}`)
      .then(res => {
        setUserData(res.data);
        setLoading(false);
      })
      .catch(err => {
        setError('Error fetching service details.');
        setLoading(false);
      });
  }, [userId]);


  const renderTabContent = () => {
    if (!userData) return null;


    switch (activeTab) {
      case 'overview':
        return (
          <div>
            <h4>
              <span className="material-symbols-outlined" style={{
                verticalAlign: 'middle',
                marginRight: '12px',
                color: '#333'
              }}>
                info
              </span>
              Service Overview
            </h4>
           
            <div style={{
              border: '1px solid #eee',
              borderRadius: '8px',
              padding: '15px',
              marginTop: '10px'
            }}>
              <p><strong>Service Name:</strong> {userData.service_title}</p>
              <p><strong>Description:</strong> {userData.service_description}</p>
              <p><strong>Capacity:</strong> {userData.capacity_jobs} jobs</p>
              {/* <p><strong>Created Date:</strong> {new Date(userData.created_date).toLocaleDateString()}</p>
              <p><strong>Last Updated:</strong> {new Date(userData.updated_date).toLocaleDateString()}</p> */}
            </div>
          </div>
        );


      case 'tasks':
        return (
          <div style={{ marginTop: '15px' }}>
            <h4>
              <span className="material-symbols-outlined" style={{
                verticalAlign: 'middle',
                marginRight: '8px',
                color: '#333'
              }}>
                assignment
              </span>
              Service Tasks
            </h4>
            <div style={{
              border: '1px solid #eee',
              borderRadius: '8px',
              padding: '15px',
              marginTop: '10px'
            }}>
              <CommonTaskList
                presetFilters={{ service_id: userId }}
                rowsPerPage={5}
                initialSearchQuery=""
              />
            </div>
          </div>
        );


      case 'usage':
        return (
          <div>
            <h4>
              <span className="material-symbols-outlined" style={{
                verticalAlign: 'middle',
                marginRight: '8px',
                color: '#333'
              }}>
                trending_up
              </span>
              Service Usage
            </h4>
            <div style={{
              border: '1px solid #eee',
              borderRadius: '8px',
              padding: '20px',
              marginTop: '10px',
              textAlign: 'center',
              color: '#666'
            }}>
              <p>Usage statistics will be displayed here</p>
              {/* You can add actual usage data visualization here */}
            </div>
          </div>
        );


      case 'settings':
        return (
          <div>
            <h4>
              <span className="material-symbols-outlined" style={{
                verticalAlign: 'middle',
                marginRight: '8px',
                color: '#333'
              }}>
                settings
              </span>
              Service Settings
            </h4>
            <div style={{
              border: '1px solid #eee',
              borderRadius: '8px',
              padding: '20px',
              marginTop: '10px',
              textAlign: 'center',
              color: '#666'
            }}>
              <p>Service configuration options will be displayed here</p>
              {/* You can add service settings form here */}
            </div>
          </div>
        );


      default:
        return null;
    }
  };
  if (loading) {
    return (
      <Modal title="View Service" onClose={onClose}>
        <div>Loading service details...</div>
      </Modal>
    );
  }






  if (error) {
    return (
      <Modal title="View Service" onClose={onClose}>
        <div style={{ color: 'red' }}>{error}</div>
      </Modal>
    );
  }


  return (
    <Modal  onClose={onClose}>
      <div style={{ height: '100%', overflow: 'hidden' }}>
        {/* Header */}
        <div style={{
          display: 'flex',
          alignItems: 'center',
          gap: '20px',
          padding: '0px 10px 10px',
          borderBottom: '1px solid #e0e0e0'
        }}>
          <div style={{
            width: '60px',
            height: '60px',
            borderRadius: '50%',
            backgroundColor: '#e0e0e0',
            color: '#000',
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'center',
            fontSize: '20px',
            fontWeight: 'bold'
          }}>
            {userData.service_title?.charAt(0)?.toUpperCase() || 'S'}
          </div>
          <div>
            <h3 style={{ margin: '0px', fontWeight: 'bold', fontSize: '20px', color: 'black' }}>
              {userData.service_title}
            </h3>
            <p style={{ marginTop: '5px', fontSize: '16px', color: 'black', fontWeight: 'bold' }}>
              ID : #{userData.
s_id|| userId}
            </p>
          </div>
        </div>


        {/* Tabs */}
        <div style={{
          display: 'flex',
          borderBottom: '1px solid #e0e0e0',
          marginBottom: '20px',
          padding: '20px +6px'
        }}>
          {TAB_CONFIG.map(tab => (
            <button
              key={tab.id}
              style={{
                padding: '2px 16px',
                border: 'none',
                backgroundColor: 'transparent',
                cursor: 'pointer',
                fontSize: '14px',
                fontWeight: activeTab === tab.id ? '400' : '400',
                color: activeTab === tab.id ? '#34c759' : '#333',
                position: 'relative',
                whiteSpace: 'nowrap',
                minWidth: activeTab === tab.id ? '100px' : '50px',
                textAlign: 'center',
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
                gap: '8px'
              }}
              onClick={() => setActiveTab(tab.id)}
              onMouseEnter={() => setHoveredTab(tab.id)}
              onMouseLeave={() => setHoveredTab(null)}
            >
              <span className="material-symbols-outlined" style={{
                color: activeTab === tab.id ? '#34c759' : '#333',
                fontSize: '20px'
              }}>
                {tab.icon}
              </span>
              {(activeTab === tab.id || hoveredTab === tab.id) && <span>{tab.label}</span>}
              {activeTab === tab.id && (
                <div style={{
                  position: 'absolute',
                  bottom: '-20px',
                  left: '0',
                  right: '0',
                  height: '2px',
                  backgroundColor: '#34c759'
                }} />
              )}
            </button>
          ))}
        </div>


        {/* Content */}
        <div style={{ padding: '0 20px', overflow: 'hidden' }}>
          {renderTabContent()}
        </div>
      </div>
    </Modal>
  );
};


export default ServicesView;