import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const UserDB = ({ userId, onClose, onDeleteSuccess }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deleteUser = () => {
    if (isSubmitting) return;
    setSubmitting(true);
    axios.delete(`/services/${userId}`)
      .then(res => {
        alert("Service deleted successfully.");
        if (onDeleteSuccess) onDeleteSuccess();
        onClose();
      })
      .catch(err => {
        setError("Error deleting user.");
      })
      .finally(() => {
        setSubmitting(false);
      });
  };

  return (
    <Modal title="Delete Service" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete or block this service?</p>
      <button onClick={deleteUser} disabled={isSubmitting} style={{ marginRight: '10px' }}>Confirm</button>
      <button onClick={onClose}>Cancel</button>
    </Modal>
  );
};

export default UserDB;