import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import ServicesForm from './ServicesForm';

// Add this helper function
const dataURLtoFile = (dataurl, filename) => {
  const arr = dataurl.split(',');
  const mime = arr[0].match(/:(.*?);/)[1];
  const bstr = atob(arr[1]);
  let n = bstr.length;
  const u8arr = new Uint8Array(n);
  while (n--) {
    u8arr[n] = bstr.charCodeAt(n);
  }
  return new File([u8arr], filename, { type: mime });
};

const NewServices = ({ onClose, onCreateSuccess }) => {
  const handleSubmit = async (formData) => {
    try {
      const formDataToSend = new FormData();
      
      // Append non-file fields
      Object.keys(formData).forEach(key => {
        if (key !== 'image' && key !== 'map_icon') {
          formDataToSend.append(key, formData[key]);
        }
      });

      // Process image file
      if (formData.image && formData.image.startsWith('data:')) {
        const timestamp = Date.now();
        const imageFile = dataURLtoFile(formData.image, `service-${timestamp}.png`);
        formDataToSend.append('image', imageFile);
      }

      // Process map icon file
      if (formData.map_icon && formData.map_icon.startsWith('data:')) {
        const timestamp = Date.now();
        const iconFile = dataURLtoFile(formData.map_icon, `map-icon-${timestamp}.png`);
        formDataToSend.append('map_icon', iconFile);
      }

      const response = await axios.post('/services/', formDataToSend, {
        headers: {
          'Content-Type': 'multipart/form-data'
        }
      });

      alert("Service created successfully!");
      if (onCreateSuccess) onCreateSuccess(response.data);
      if (onClose) onClose();
    } catch (err) {
      console.error("Error creating service:", err);
      alert("Error creating service.");
    }
  };

  return (
    <div>
      <ServicesForm onSubmit={handleSubmit} />
    </div>
  );
};

export default NewServices;

