import React from 'react';
import Tabs from '../../common/Tabs';
import ScheduleList from './ScheduleList';
import AddSchedule from './AddSchedule';

const Schedules = () => {
  const tabsData = [
    { id: 'schedule_list', label: 'Schedules' },
    { id: 'new_schedule', label: 'Add ' },
  ];

  return (
    <div className="schedules-container">
    
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'schedule_list':
              return <ScheduleList />;
            case 'new_schedule':
              return <AddSchedule />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Schedules;